﻿// <copyright file="BaseFunctionBlock.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

define(['common/Enums', 'base/Model', 'common/Error', 'common/Utilites', 'controls/ParametersFactory'],
    function (Enums, Model, Error, Utilites,  ParametersFactory) {
        
        var JsonVariablesManagerModel = Model.extend({
            init: function (type) {                
                this._super();
                this.ClassName = 'JsonVariablesManagerModel';
                //this._data[Enums.ParameterRoles.VALUE] = ParametersFactory.createByType(type);
                this._data = type.parameters;
            },

            getIsActive: function () {
                return true; //this.get(Enums.ParameterRoles.IS_ENABLED);
            },

            getInterval: function () {
                return this.get(Enums.ParameterRoles.INTERVAL);
            },

            setJson: function (propName, object) {
                if (!this._checkPropertyExists(this._data, propName)) {
                    return;
                }

                if (this._data[propName].typeName === Enums.serverType.string) {
                    //JSON при строковом параметре записываем как строку
                    this._data[propName].value =  JSON.stringify(object);
                } else {
                    try{
                        this._setJsonValue(this._data, propName, object, '');
                    } catch (e) {
                        Error.exception(e);
                    }
                }
            },

            _setJsonValue: function (propContainerObject, propName, object, fullPath) {
                if (object instanceof Array) {
                    this._setJsonArray(propContainerObject, propName, object, fullPath);
                } else if (object instanceof Object) {
                    this._setJsonObject(propContainerObject, propName, object, fullPath);
                } else {
                    this._setJsonElementary(propContainerObject, propName, object, fullPath);
                }
            },
           
            _setJsonArray: function (propContainerObject, propName, array, fullPath) {
                var i;                
                fullPath = (fullPath !== '' ? '.' : '') + fullPath + propName;
                var currentPropArray = propContainerObject[propName].value;
                var delta = currentPropArray.length - array.length;
                if (delta > 0 ) {
                    currentPropArray.splice(array.length, delta);
                } else if (delta < 0) {
                    var type = ParametersFactory.getType(propContainerObject[propName].typeName);
                    for (i = currentPropArray.length; i < array.length ; i++) {
                        currentPropArray[i] = ParametersFactory.createByType(type.description.arrayItemType);
                    }
                }

                for (i = 0; i < array.length; i++) {
                    this._setJsonValue(propContainerObject[propName].value, i, array[i], fullPath + '[' + i + ']');
                }
            },

            _setJsonObject: function (propContainerObject, propName, object, fullPath) {
                fullPath = (fullPath !== '' ? '.' : '') + fullPath + (Utilites.isNumber(propName) ? '' : propName);
                _.forOwn(object, function (fieldObject, fieldName) {
                    this._setJsonValue(propContainerObject[propName].value, fieldName, fieldObject, fullPath + '.' + fieldName);
                }, this);
            },

            _setJsonElementary: function (propContainerObject, propName, value, fullPath) {
                if (!this._checkPropertyExists(propContainerObject, propName)) {
                    return;
                }              

                fullPath = fullPath !== '' ?  fullPath : propName;

                var oldProperty = $.extend(true, {}, propContainerObject[propName]);
                propContainerObject[propName].value = value;
                if (!Utilites.compareValues(propContainerObject[propName].value, oldProperty.value)) {
                    this.firePropertyChanged(fullPath, oldProperty, propContainerObject[propName]);
                }
            },

            getJson: function (propName) {
                if (!this._checkPropertyExists(this._data, propName)) {
                    return;
                }
                return this._getJsonValue(this._data, propName);
            },

            _getJsonValue: function (propContainerObject, propName) {
                var type = ParametersFactory.getType(propContainerObject[propName].typeName);
                switch (type.type) {
                    case Enums.type.array:
                        return this._getJsonArray(propContainerObject, propName);
                    case Enums.type.object:
                        return this._getJsonObject(propContainerObject, propName);
                    default:
                        return  this._getJsonElementary(propContainerObject, propName)
                }              
            },
            
            _getJsonArray: function (propContainerObject, propName) {
                var arr = [],
                    i,
                    containerArr = propContainerObject[propName].value;
                
                for (i = 0; i < containerArr.length; i++) {
                    arr.push(this._getJsonValue(containerArr, i));
                }

                return arr;
            },

            _getJsonObject: function (propContainerObject, propName) {
                var obj = {};
                _.forOwn(propContainerObject[propName].value, function (fieldObject, fieldName) {
                    obj[fieldName] = this._getJsonValue(propContainerObject[propName].value, fieldName);
                }, this);

                return obj;
            },

            _getJsonElementary: function (propContainerObject, propName) {
                if (!this._checkPropertyExists(propContainerObject, propName)) {
                    return;
                }

                return propContainerObject[propName].value;
            },


            _checkPropertyExists: function (propContainerObject, propName) {
                if (!propContainerObject[propName]) {
                    Error.onerror(String.format('Property {0} is not exists.', propName));
                    return false;
                }

                return true;
            }      
        });


        return JsonVariablesManagerModel;
    });
