// <copyright file="RequestManagerState.js" company="">
// , 2014
// </copyright>
// 

define(['server/ServerStateManager', 'common/Enums'],
    function (ServerStateManager, GlobalEvents, Enums) {

        var RequestManagerState = ServerStateManager.extend({

            init: function (options) {              
                this._super();
                this.state = $.extend(this.state, {
                    requestedPublishingInterval: 1000,
                    requestedLifetimeInterval: 0,
                    maxNotificationsPerPublish: 0,
                    maxSize: 1000,
                    SubscriptionId: -1,
                    Connected: false,
                    taskId: 0,
                    itemId: 0,
                    path: '',
                }, options);
            },

            setOptions: function (options) {
                _.forOwn(options, function (option, key) {
                    this.set(key, option, true);
                }, this);
            },

            setConnected: function (value) {
            }
        });

        return RequestManagerState;
    });