﻿define(['meld', 'server/ServerLogger', 'common/Enums'],
    function (meld, Logger, Enums) {

        function MeldConfig() {

        };

        function logBeforeMessage(args) {
            var joinpoint = meld.joinpoint();
            var message = "Method: " + joinpoint.method + " Called with: " + args;
            logMessage(message);
        }

        function logAfterMessage(returnValue) {
            var joinpoint = meld.joinpoint();
            var message = "Method: " + joinpoint.method + " Returned: " + toJson(returnValue);
            logMessage(message);
        }

        function logMessage(message) {
            console.log(message);
            Logger.logMessage(message, Enums.logLevel.waring);
        }

        function toJson(parameters) {
            return typeof parameters == 'string' ? parameters : $.toJSON(parameters)
        }

        MeldConfig.prototype.advice = {
            /* "WindowController/onParentActualHeightChanged": {
                 before: function () {
                     logBeforeMessage.call(this, arguments);
                 },
                 after: function (returnValue) {
                     logAfterMessage.call(this, returnValue);
                 }
             },
             "SchemeController/onWindowResizeHandler": {
                 before: function () {
                     logBeforeMessage.call(this, arguments);
                 },
                 after: function (returnValue) {
                     logAfterMessage.call(this, returnValue);
                 }
             }*/
        },

         MeldConfig.prototype.getAdvice = function () {
             var objects = {}; //win : show, hide
             _.forOwn(this.advice, function (advice, path) {
                 var arr = path.split("/");
                 var objectClass = arr[0];
                 var objectMethod = arr[1];

                 if (objects[objectClass] === undefined) {
                     objects[objectClass] = {};
                 }

                 objects[objectClass][objectMethod] = advice;
             });

             return objects;
         }


        return new MeldConfig();
    });