// <copyright file="WindowControl.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 
define(['controls/496867/496867Type', 'controls/Window/WindowModel', 'controls/Window/WindowController',
'core/Statistic', 'common/Enums'],
    function (controlType, WindowModel, WindowController,  Statistic, Enums) {

        return function (parentResourceManager, model) {
            var statisticId = Statistic.startMeasurement(Enums.statisticType.window);
            var win =  $$({
                model: new WindowModel(controlType, parentResourceManager),
                view: { 
                    format: model.cssClass
                },
                controller: new WindowController(statisticId)
            });

            return win;
        };
    });