﻿// <copyright file="ClockModel.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

/*
* @class ClockModel model class for Clock control
*/
define(['common/Enums', 'controls/Label/LabelModel'],
function (Enums, LabelModel) {
    
    var ClockModel = LabelModel.extend({
        dateTimeSeparator: ' ',

        init: function (type, parentResourceManager) {
            this._super(type, parentResourceManager);

            this.ClassName = 'ClockModel';
        },

        getDateFormat: function () {
            var dateFormat = this.get(Enums.ParameterRoles.DATE_FORMAT);
            if (!dateFormat) {
                return "MM/dd/yyyy";
            }

            return dateFormat;
        },

        getTimeFormat: function () {
            var timeFormat = this.get(Enums.ParameterRoles.TIME_FORMAT);
            if (!timeFormat) {
                return "HH:mm:ss";
            }

            return timeFormat;
        },

        getDateTimeFormat: function () {
            switch (this.get(Enums.ParameterRoles.DATE_TIME_TYPE)) {
                case Enums.DateTimePickerType.DATE:
                    return this.getDateFormat();
                case Enums.DateTimeType.Time_Type:
                    return this.getTimeFormat();
                case Enums.DateTimePickerType.DATETIME:
                    return this.getDateFormat() + this.dateTimeSeparator + this.getTimeFormat();
                case Enums.DateTimeType.Time_TypeDATE:
                    return this.getTimeFormat() + this.dateTimeSeparator + this.getDateFormat();
            }
        },

    });

    return ClockModel;
});
