﻿define(['common/Enums', 'common/Error', 'common/Appearence', 'base/ControlController'], function (Enums, Error, Appearence, ContainerController) {

    var ContentButtonController = ContainerController.extend({
        init: function () {
            this._super();
            this.ClassName = 'ColorPickerButtonController';
        },
        onAddedToDOM: function () {
            this._super();
            var that = this;
            this.instance = this.mvc.view.$().colorPicker({
                forceAlpha: true,
                renderCallback: function ($elm, toggled) {
                    var alpha;
                    if (this.color.colors.alpha < 1.0) {
                        alpha = Math.round(this.color.colors.alpha * 256).toString(16);
                        if (alpha.length == 1) {
                            alpha = "0" + alpha;
                        }
                    } else {
                        alpha = "";
                    }
                    var color = "#" + alpha + this.color.colors.HEX;
                    that.mvc.model.setColorSelect(color);
                //    console.log(toggled, color, that.mvc.model.getColorSelect());
                }
            });
            this.onColorSelectChanged(this.mvc.model.getColorSelect());
        },
        modelPropertyChangedInternal: function (event) {
            this._super(event);
            var value = this.mvc.model.get(event.property);
            switch (event.property) {
                case Enums.ParameterRoles.COLOR_SELECT:
                    this.onColorSelectChanged(value);
                    break;
            }
        },
        onBackgroundChanged: function(value){

        },

        onColorSelectChanged: function (value) {
            this.mvc.view.$()[0].value = Appearence.color.toCssColor(value);
           Appearence.background.apply(this.mvc.view.$(), value);
        //   var color = Appearence.color.ARGBtoObj(value);
        }
    });

    return ContentButtonController;
});