﻿// <copyright file="ComboBoxModel.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

/*
* @class ComboBoxModel model class for ComboBox control
*/
define(['common/Enums', 'base/TextControlModel'],
function (Enums, TextControlModel) {

    var ComboBoxModel = TextControlModel.extend({

        init: function (type, parentResourceManager) {
            this._super(type, parentResourceManager);

            this.ClassName = 'ComboBoxModel';
        },

        getSelectedValue: function () {
            return this.get(Enums.ParameterRoles.SELECTED_ITEM);
        },

        setSelectedValue: function (value) {
            this.set(Enums.ParameterRoles.SELECTED_ITEM, value);
        },

        getItems: function () {
            return this.get(Enums.ParameterRoles.ITEM_SOURCE);
        }
    });

    return ComboBoxModel;
});
