﻿// <copyright file="FrameController.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 


define(['common/Enums', 'base/ContainerController', 'core/WindowsManager', 'server/sources/SchemeVariablesSource'],
    function (Enums, ContainerController, WindowsManager, SchemeVariablesSource) {

        var ControlFactory;

        //broke cirle dependencies
        curl(['controls/ControlFactory'], function (cf) {
            ControlFactory = cf;
        });

        var FrameController = ContainerController.extend({

            init: function () {
                this._super();
                this.frameWindow = null;
                this.ClassName = 'FrameController';
            },

            onAddedToDOM: function(){
                this.updateChildWindowSize();
                this._super();
                this.initialized = true;
            },

            updateChildWindowSize: function () {
                if (!this.frameWindow) {
                    return;
                }
                if (this.mvc.model.getSizeContent() === Enums.SizeToContentType.SetSize) {
                    this.frameWindow.controller.setControlHeight('100%');
                    this.frameWindow.controller.setControlWidth('100%');
                } else {
                    this.proportionFixedSide = null;
                    this.sideRation = null;
                }
                this._applyPropotions();
                this.frameWindow.controller.preventChangeProportions = false;
            },

            setWindowById: function (windowModelId, addToSubscription) {
                var windowModel = WindowsManager.getWindowModelById(windowModelId);
                this.setWindow(windowModel, addToSubscription);
            },

            setWindow: function (windowModel, addToSubscription) {
                //первым, т.к действию надо забрать параметры
                this.mvc.model.set(Enums.ParameterRoles.DATA_SOURCE, windowModel.parameters.Id.value);

                if (this.frameWindow) {
                    this.removeChildControl(this.frameWindow);
                }
                this.frameWindow = null;

                this.frameWindow = this.addChildControl(this.mvc, windowModel,
                    this.mvc.model.resourceManager);

                //ввостинавливаем изначальное поведение
                if (this.mvc.model.getSizeContent() === Enums.SizeToContentType.Crop && this._isRelativeSizes()) {
                    //crop в относительных обрабатывается как RC
                    this.mvc.model.setSizeContent(Enums.SizeToContentType.SetSize);
                }

                this.initFrame(this.frameWindow);

                if (this.initialized === true) {
                    this.updateChildWindowSize();
                }

                // addToSubscription - true, если меняем окно акшеном
                // false - если ставим при создании окна (схема сама всех подпишет)
                if (addToSubscription === true) {
                    SchemeVariablesSource.subscribe();
                }
            },

            initFrame: function (frameWindow) {
                switch (this.mvc.model.getSizeContent()) {
                    case Enums.SizeToContentType.RealSize:
                        //убираем пропорции, т.к окно в ResizeWindow должно отображаться без учета пропорций
                        frameWindow.model.set(Enums.ParameterRoles.PROPORTION_TYPE, Enums.ProportionType.No);
                        frameWindow.controller.sideRatio = null;
                        frameWindow.controller.proportionFixedSide = null;
                        var width = this.mvc.model._data.Width;
                        var height = this.mvc.model._data.Height;
                        if (!width || !width.value) this.mvc.model._data.Width = frameWindow.model._data.Width;
                        if (!height || !height.value) this.mvc.model._data.Height = frameWindow.model._data.Height;
                        break;
                    case Enums.SizeToContentType.SetSize:
                        //всегда трактуем окна как окно с относительными размерами 
                        frameWindow.controller.preventChangeProportions = true;
                        frameWindow.model.set(Enums.ParameterRoles.WIDTH_UNITS, Enums.SizeType.Relative, true);
                        frameWindow.model.set(Enums.ParameterRoles.HEIGHT_UNITS, Enums.SizeType.Relative, true);
                        frameWindow.controller.preventChangeProportions = false;
                        if (this._isApplyProportions()) {
                            this.propType = frameWindow.model.get(Enums.ParameterRoles.PROPORTION_TYPE);
                            this.calculateChildWindowProportions(this.mvc.view.$().height(), this.mvc.view.$().width());
                        } else {
                            //уменьшаем размер окна до размера диалога  без сохранения пропорций
                            this.propType = Enums.ProportionType.No;
                            frameWindow.model.set(Enums.ParameterRoles.PROPORTION_TYPE, Enums.ProportionType.No);
                        }

                        break;
                    case Enums.SizeToContentType.Crop:
                        //отображаем в размерах редактора без пропорций           
                        //диалогу и контейнеру ставим заданные в редакторе размеры   
                        frameWindow.model.set(Enums.ParameterRoles.WIDTH_UNITS, Enums.SizeType.Pixel);
                        frameWindow.model.set(Enums.ParameterRoles.HEIGHT_UNITS, Enums.SizeType.Pixel);
                        this.mvc.view.$().css('overflow', 'hidden');
                        break;
                    case Enums.SizeToContentType.Scroll:
                        //отображаем в размерах редактора без пропорций           
                        //диалогу и контейнеру ставим заданные в редакторе размеры   
                        frameWindow.model.set(Enums.ParameterRoles.WIDTH_UNITS, Enums.SizeType.Pixel);
                        frameWindow.model.set(Enums.ParameterRoles.HEIGHT_UNITS, Enums.SizeType.Pixel);
                        this.mvc.view.$().css('overflow', 'scroll');
                        break;
                }
            },

            _isApplyProportions: function () {
                //WI 10640 - абсолютные воспринимать как относительные
                return this.frameWindow.model.get(Enums.ParameterRoles.PROPORTION_TYPE) !== Enums.ProportionType.No;
            },

            _isRelativeSizes: function(){
                return this.frameWindow.model.get(Enums.ParameterRoles.WIDTH_UNITS) === Enums.SizeType.Relative &&
                    this.frameWindow.model.get(Enums.ParameterRoles.HEIGHT_UNITS) === Enums.SizeType.Relative;
            },

            _applyPropotions: function () {
                this.frameWindow.controller.proportionFixedSide = this.proportionFixedSide;
                this.frameWindow.controller.sideRatio = this.sideRation;
                this.frameWindow.controller.onParentResized();
            },

            calculateChildWindowProportions: function (frameHeight, frameWidth) {
                var childWindowHeight = this.frameWindow.model.getHeight(),
                    childWindowWidth = this.frameWindow.model.getWidth(),
                    propType = this.frameWindow.model.get(Enums.ParameterRoles.PROPORTION_TYPE);

                if (propType === Enums.ProportionType.Min || propType === Enums.ProportionType.Max) {
                    var childWindowRatio = childWindowWidth / childWindowHeight;
                    var frameRatio = frameWidth / frameHeight;

                    if ((childWindowRatio <= frameRatio && propType === Enums.ProportionType.Max) ||
                        (childWindowRatio > frameRatio && propType === Enums.ProportionType.Min)) {
                        this.frameWindow.controller.setControlHeight('100%');
                        this.proportionFixedSide = Enums.ControlSide.HEIGHT;
                        this.sideRation = this.frameWindow.controller.sideRatio =
                            this.frameWindow.controller.calculateSideRatio(this.proportionFixedSide, childWindowWidth, childWindowHeight);
                    }

                    if ((childWindowRatio > frameRatio && propType === Enums.ProportionType.Max) ||
                        (childWindowRatio < frameRatio && propType === Enums.ProportionType.Min)) {
                        this.frameWindow.controller.setControlWidth('100%');
                        this.proportionFixedSide = Enums.ControlSide.WIDTH;
                        this.sideRation = this.frameWindow.controller.sideRatio =
                            this.frameWindow.controller.calculateSideRatio(this.proportionFixedSide, childWindowWidth, childWindowHeight);
                    }
                } else {
                    //сохраняем оригинальные пропорции окна
                    if (this.propType !== Enums.ProportionType.No) {
                        this.frameWindow.controller.calculateResizeProportions();
                        this.sideRation = this.frameWindow.controller.sideRatio;
                        this.proportionFixedSide = this.frameWindow.controller.proportionFixedSide;
                    }
                }
            },

            onAfterModelInit: function () {
                var windowModel = this.mvc.model.get(Enums.ParameterRoles.DATA_SOURCE);
                if (windowModel){
                    if (!isNaN(windowModel)) {
                        this.setWindowById(windowModel, false);
                    } else {
                        this.mvc.view.$()[0].innerHTML = '<iframe style="width:100%;height:100%;" sandbox="allow-scripts allow-same-origin allow-forms" frameborder="0" src="' + windowModel + '" />';
                    }
                }
            },

            onParentActualWidthChanged: function (event) {
                if (!window.initialized)
                    return;
                this._onParentSizeChanged();
                this._super(event);
            },

            onParentActualHeightChanged: function (event) {
                if (!window.initialized)
                    return;
                this._onParentSizeChanged();
                this._super(event);
            },

            fireActualWidthChanged: function (newValue) {
            },

            fireActualHeightChanged: function (newValue) {
            },

            _onParentSizeChanged: function () {
                if (this.frameWindow !== null && this.mvc.model.getSizeContent() === Enums.SizeToContentType.SetSize) {
                    this.calculateChildWindowProportions(this.mvc.view.$().height(), this.mvc.view.$().width());
                    this.updateChildWindowSize();
                }
            },

            getNestedWindow: function () {
                return this.frameWindow;
            }

        });

        return FrameController;
    });
