﻿// <copyright file="FilterPanel.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

define(['base/EventTarget', 'common/Enums', 'common/Appearence', 'helpers/PathBuilder',
    'controls/Journal/modules/filter/Filter'], function (EventTarget, Enums, Appearence,
        PathBuilder, Filter) {
    var placeholder = 'filter';

    var filterBarProto = {
        view: {
            format: '<div class="journal-filter"><ul></ul></div>'
        }
    }  

    var FilterPanel = Class.extend({
        init: function (journalModel) {
            this.model = journalModel;
            this.model.subscribePropertyChanged(this.onModelPropertyChanged, this);
            this.filterBar = null;         
            this.filters = [];       
            this.width = null;
            this._createFilterBar();            
        },

        _createFilterBar: function () {
            this.filterBar = $$(filterBarProto);
            var filters = this.model.getFilters();
            var i;
            for (i = 0; i < filters.length; i++) {
                var filter = new Filter(i, this.model);
                this.filters.push(filter);               
            }         
        },

        render: function (container) {
            for (var i = 0; i < this.filters.length; i++) {
                this.filters[i].render(this.filterBar.view.$());
            }

            container.find(String.format('[placeholder="{0}"]', placeholder)).append(this.filterBar.view.$());
            this.width = this.filterBar.view.$().width();
            this.height = this.filterBar.view.$().height();
            this._onShowFilterChanged();
            this._onIsEnabledChanged();
        },

        onModelPropertyChanged: function (event) {
            var pathArray = new PathBuilder(event.property).getArray();         

            switch (event.property) {
                case Enums.ParameterRoles.IS_ENABLED:
                    this._onIsEnabledChanged();
                    break;
            }

            if (pathArray[0] === Enums.ParameterRoles.SHOW_FILTER) {
                this._onShowFilterChanged();
            }

        },

        _onShowFilterChanged: function () {
            Appearence.applyVisibility(this.filterBar.view.$(), this.model.get(Enums.ParameterRoles.SHOW_FILTER));
        },

        _onIsEnabledChanged: function () {
            var isEnabled = this.model.get(Enums.ParameterRoles.IS_ENABLED);
            var i;
            for (i = 0; i < this.filters.length; i++) {
                var canDisable = this.filters[i].model.getCanDisable();
                this.filters[i].filter.view.$().prop("disabled", !(isEnabled && canDisable));
            }         
        },

        getHeight: function () {
            return this.height;
        },

        getWidth: function () {
            return this.width;
        }
  
    });

    return FilterPanel;
});