﻿// <copyright file="MessageIndicatorController.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

define(['common/Enums', 'base/ControlController',
    'common/Appearence', 'server/requestManager/RequestManager',
    'core/actions/OpenJournalAction', 'core/WindowsManager',
    'common/Error', 'controls/ControlTypeFactory', 'core/L10n'],
    function (Enums, ControlController,
        Appearence, RequestManager, OpenJournalAction, WindowsManager, Error, ControlTypeFactory, L10n) {

        var MessageIndicatorController = ControlController.extend({

            init: function () {
                this._super();
                this.messages = [];
                this.ClassName = 'MessageIndicatorController';
                this.initialized = false;
            },

            onAddedToDOM: function () {
                this._addOpenJournalAction();
                this.requestManager = this._createRequestManager();
                var objectUid = this.mvc.model.get(Enums.ParameterRoles.OBJECT_UID);
                if (objectUid != "") {
                    this.requestManager.setObject(objectUid);
                } else {
                    this.requestManager.setObject(this.getParentObject());
                }
                this.requestManager.subscribe();
                this.initialized = true;
                this._setNoNewMessagesIcon();
            },

            onDestroy: function () {
                this._super();
                this.requestManager.unsubscribe();
                this.initialized = false;
            },
            attachEvents: function () {
                var self = this;
                this.mvc.view.$().click(function (event) { self.onClick(event); });
            },
            onClick: function (event) {
                if (WindowsManager.getWindowModelById(this.mvc.model.getDataSource()) === undefined) {
                    Error.warn(L10n.get('messages.noJournal'));
                    return;
                }
                var dialog = this.openDialogAction;
                if (dialog.dialogContainer) {
                    return;
                }
                dialog.execute(this);
            },

            onResourceChanged: function (value) {
                var resourceUrl;
                if (!value) {
                    resourceUrl = 'scripts/controls/MessageIndicator/styles/images/no_messages.png';
                }
                else {
                    resourceUrl = this.mvc.model.resourceManager.resolve(value);
                }
                Appearence.background.applyBgImage(this.mvc.view.$(), resourceUrl);
                this.mvc.view.$().css("background-repeat", "no-repeat");
            },

            _setNewMessageIcon: function () {
                if (!this.mvc.view.$('#counter')[0]) {
                    this.mvc.view.$().append("<div id ='counter'></div>");
                    this.mvc.view.$('#counter').append("<p></p>");
                    var counterCss = {
                        'position': 'absolute',
                        "width": "25%",
                        'height': "25%",
                        'margin-left': '75%',
                        'background-color': '#f00',
                        'border-radius': '100%'
                    };
                    var textCss = {
                        'position': 'absolute',
                        'top': '50%',
                        'left': '50%',
                        'transform': 'translate(-50%, -50%)',
                        'font-weight': 'bold',
                        'font-size': '1.4vmin',
                        'font-family': 'Verdana',
                        'text-align': 'center',
                        'color': '#fff'
                    };
                    this.mvc.view.$('#counter').css(counterCss);
                    this.mvc.view.$('p').css(textCss);
                }

                var count = this.messages.length;
                if (count > 99) count = '99+';
                this.mvc.view.$('p').text(count);
            },

            _setNoNewMessagesIcon: function () {
                if (this.mvc.view.$('#counter')[0]) {
                    this.mvc.view.$('#counter')[0].remove();
                }
            },

            _createRequestManager: function () {
                var requestManager = new RequestManager(this.mvc.model.getOptionsForEM());
                requestManager.setFilters(this.mvc.model.getFiltersForEM(), true);
                requestManager.setColumns(this.mvc.model.getColumnsForEM());
                requestManager.subscribeMessagesChanged(this._onNewMessagesReceived, this);

                return requestManager;
            },

            _onNewMessagesReceived: function (event) {
                for (var i = 0; i < event.newOrUpdated.length; i++) {
                    var curMes = event.newOrUpdated[i].EventId.substring(0, 16);
                    if (this.messages.indexOf(curMes) == -1) {
                        this.messages.push(curMes);
                    }
                }
                for (var i = 0; i < event.deleted.length; i++) {
                    var curMesDel = event.deleted[i].substring(0, 16);
                    var indexToDelete = this.messages.indexOf(curMesDel);
                    if (indexToDelete != -1) {
                        this.messages.splice(indexToDelete, 1);
                    }
                }
                if (this.messages.length > 0) {
                    this.mvc.model.set(Enums.ParameterRoles.HAS_MESSAGES, true);
                    this._setNewMessageIcon();
                } else {
                    this.mvc.model.set(Enums.ParameterRoles.HAS_MESSAGES, false);
                    this._setNoNewMessagesIcon();
                }
            },

            _addOpenJournalAction: function () {
                var windowModeloriginal = WindowsManager.getWindowModelById(this.mvc.model.getDataSource());
                if (windowModeloriginal === undefined) {
                    //    Error.warn(L10n.get('messages.noJournal'));
                    return;
                }

                this.openDialogAction = new OpenJournalAction({
                    id: this.mvc.model.getId() + '_openJournal',
                    type: Enums.ActionType.openDialog,
                    constants: {
                        WindowId: this.mvc.model.getDataSource(),
                        CanMinimize: true,
                        CanResize: true,
                        Behaviour: Enums.SizeToContentType.RealSize,
                        Title: "",
                        Background: "#FFE0E0FF",
                        Width: windowModeloriginal.parameters.Width.value,
                        Height: windowModeloriginal.parameters.Height.value,
                    },
                    parameters: {}
                });

                var journalWrapperType = $.extend(true, {}, ControlTypeFactory.getType(windowModeloriginal.typeName));
                $.extend(true, journalWrapperType.childModels[0].parameters, {
                    Filters: this.mvc.model.getFiltersProperty(),
                    ObjectUID: this.mvc.model.getObjectUIDProperty()
                });

                this.openDialogAction.addTypeReplaceParameters(journalWrapperType);
                this.openDialogAction.replaceModelParams(this.openDialogAction.constants);
                if (windowModeloriginal.parameters.Width.value < 800) {
                    var width = this.mvc.model.getProperty(Enums.ParameterRoles.WIDTH);
                    width.value = 800;
                    this.openDialogAction.addReplacedParameter({ Width: width });
                }
            },
            onRender: function () {

            }
        });

        return MessageIndicatorController;
    });
