﻿// <copyright file="SchemeController.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

define(['meld', 'common/MeldConfig', 'common/Enums', 'common/Appearence', 'base/CanvasContainerController',
    'core/WindowsManager', 'server/Server',  'controls/Scheme/SchemePreloader', 'core/L10n',
 'server/ServerLogger', 'core/global/GlobalEvents', 'core/functionBlocks/TaskManager',
    'common/Utilites', 'server/sources/SchemeVariablesSource', 'server/VariablesManagersHandler', 'common/Error', 'core/global/GlobalSettingsType'],
function (meld, MeldConfig, Enums, Appearence, CanvasContainerController, WindowsManager, Server,
    SchemePreloader, Localisation, ServerLogger, GlobalEvents, TaskManager, Utilites, 
    SchemeVariablesSource, VariablesManagersHandler, Error, GlobalSettings) {

    var SchemeController = CanvasContainerController.extend({
        
		init: function () {
			this._super();
			this.ClassName = 'SchemeController';
			this.advice = [];
			this.variablesSource = null;
			this.onWindowResizeBind = this.onWindowResize.bind(this);
			window.initialized = false;
		},

		onAddedToDOM: function () {
		    this._super();
		    if (this.mvc.model.get(Enums.ParameterRoles.DISABLE_SCALE)) {
		        $("head").append('<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">');
		        $(window).on('resize', this, this.onWindowResizeBind);
		    }
		    Appearence.addFlashStyle(this.mvc.model.get(Enums.ParameterRoles.FLASH_INTERVAL));
		},

		renderOverflow: function () {
			// do nothing here
		},

		applyWidth: function () {
			// do nothing here
		},

		applyHeight: function () {
			// do nothing here
		},

		renderPosition: function () {
			// do nothing here
		},
		onCreate: function () {
		    Server.init(this.mvc.model.get(Enums.ParameterRoles.REQUEST_SERVER_PREFIX));
		    this.variablesSource = SchemeVariablesSource;
		    this.variablesSourcePropertyChangedInternalBind = this.variablesSourcePropertyChangedInternal.bind(this);
		    this.taskManagerPropertyChangedInternalBind = this.taskManagerPropertyChangedInternal.bind(this);		   		  

		    this._initTaskManager();

		    this._super();
		    this.mvc.model.set(Enums.ParameterRoles.WIDTH, window.innerWidth);
		    this.mvc.model.set(Enums.ParameterRoles.HEIGHT, window.innerHeight);
		//    $(window).on('resize', this, this.onWindowResizeBind);

		    meld.before(ServerLogger, 'logMessage', function (text, level) {
		        if (level > Enums.logLevel.info) {
		            GlobalEvents.onClientErrorOccured({ level: level, message: text });
		        }
		    });
		},

		_initTaskManager: function () {
		    if (TaskManager.getTasksCount() > 0) {
		        //если есть связи от задач экрана на серверные переменные - добавляем переменные		      
		        if (Utilites.hasServerVariables(this.mvc.model.serverVariables)) {
		            this.variablesSource.addToSubscription(this.mvc.model.serverVariables, this.mvc.model.getId());
		            this.variablesSource.subscribePropertyChanged(this.variablesSourcePropertyChangedInternalBind, this);
		          
		            //если нужны переменные по get - запускаем задачу экрана только после их прихода
		            if (Utilites.hasGetServerVariables(this.mvc.model.serverVariables)) {
		                this.variablesSource.subscribeSourceDataReady(this.onServerDataReady, this, this.mvc.model.getId());		               
		            }
		        }

		        TaskManager.subscribePropertyChanged(this.taskManagerPropertyChangedInternalBind, this);
		    }
		},

		onServerDataReady: function (event) {
		    if (event.type === Enums.eventType.sourceDataReady && event.objectId === this.mvc.model.getId()) {
		        //обновляем связи от серверных перменных к параметрам задачи		       
		        TaskManager.start();
		    }
		},

		addTypeChildControls: function () {
		    var actions = function () {
		        VariablesManagersHandler.initialize();

		        WindowsManager.addWindows(this.mvc.model.getType().getChildModels());
		        //если экран не задан - мы в режиме просмотра, окна меняются в схеме
                //иначе окна меняются в экране
		        var params = WindowsManager.setActiveWindowModel(
                    {
                        windowModel: WindowsManager.getDefaultWindow(),
                        slient: true,
                        withoutPushState: true
                    });
		        var startModel = null;
		        var hasStartScreen = this.mvc.model.hasStartScreen();
		        if (hasStartScreen) {
		            startModel = WindowsManager.getWindowModelById(this.mvc.model.getStartScreen());
		        } else {		            
		            WindowsManager.subscribeActiveWindowModelChanged(this.onActiveWindowModelChanged, this);
		            startModel = WindowsManager.getDefaultWindow();
		        }

		        if (startModel === undefined) {
		            Error.onerror('Start window model not found');
		            return;
		        }

                startModel = $.extend(true, {}, startModel);           
                startModel.url_params = params;
                this.addChildControl(this.mvc, startModel, this.mvc.model.getType().resourceManager);
                this._applyWindowSize(this.mvc.controller.orderedControls[0], startModel);                
                
		        var ctrls = this.mvc.controller.controls;
		        ctrls.scheme = this.mvc;
                this.registerMeld(ctrls);
                if (GlobalSettings.OfflineMode && GlobalSettings.OfflineMode.value != true) {
	                this.variablesSource.subscribe();
                }

		        if (!Utilites.hasGetServerVariables(this.mvc.model.serverVariables)) {
		            TaskManager.start();
		        }
		        window.initialized = true;
		        this.fireActualWidthChanged();
		        SchemePreloader.updateProgress(1);
		    }.bind(this);

		    Localisation.setLocale(this.mvc.model.get(Enums.ParameterRoles.LANGUAGE)).then(function () {
		        actions();
		    }).catch(function (e) {
                // rollback to default locale
		        Localisation.setLocale().done(function () {
		            actions();
		        });
		    });
		},

		variablesSourcePropertyChangedInternal: function (event) {
		    var path = '/' + event.property;
		    this.mvc.model.updateTypeConnection(path, this.mvc);
		},

		taskManagerPropertyChangedInternal: function (event) {
		    var path = '/' + event.property;
		    this.mvc.model.updateTypeConnection(path, this.mvc);
		},

		registerMeld: function (ctrls) {
		    var advice = MeldConfig.getAdvice();

		    _.forEach(ctrls, function (control) {
		        if (advice[control.controller.ClassName]) {
		            registerLoggerForObject(control.controller, advice);		           
		        }

		        if (advice[control.model.ClassName]) {
		            _.forOwn(advice[control.model.ClassName], function (advice, methodName) {
		                registerLoggerForObject(control.model, advice);
		            });
		        }

		    });
		},

        //chiild - окно, у него нету Х и Y
        //так же как у схемы - бордера
		getChildX: function (childControl) {
		    return 0;
		},

		getChildY: function (childControl) {
            return 0;
        },

		_applyWindowSize: function (windowControl, windowModel) {
            //метод будет вызываться только если нету экрана WI 10020

		    //если у основного окна размеры в процентах - выставляем ему размеры окна браузера
		    //при этом запрещаем менять пропорции окна
		    windowControl.controller.preventChangeProportions = true;
		    if (windowModel.parameters[Enums.ParameterRoles.WIDTH_UNITS].value === Enums.SizeType.Relative) {
		        windowControl.controller.setControlWidth('100%');
		    }

		    if (windowModel.parameters[Enums.ParameterRoles.HEIGHT_UNITS].value === Enums.SizeType.Relative) {
		        windowControl.controller.setControlHeight('100%');
		    }
		    windowControl.controller.preventChangeProportions = false;
            //обновляем размеры окна
		    windowControl.controller.onParentResized();
		},

		onActiveWindowModelChanged: function (event) {		    
		    this.removeChildControl(this.controls[event.oldWindowModel.parameters.Id.value]);
		    this.addChildControl(this.mvc, event.newWindowModel, this.mvc.model.getType().resourceManager);		    
		    this._applyWindowSize(this.mvc.controller.orderedControls[0], event.newWindowModel);
		    this.variablesSource.subscribe();
		},

		addChildControl: function (context, childModel, parentResourceManager) {
            
		    SchemePreloader.reset(childModel.totalElementsCount);
		    SchemePreloader.show();
		    this._super(context, childModel, parentResourceManager);
		    SchemePreloader.hide();
		},

		addChildControlConnections: function (context, childControl) {

		},
     
		onDestroy: function () {
		    this._super();
		    $(window).off('resize', this.onWindowResizeBind);
		},		

		onWindowResize: function () {
			var newWidth = window.innerWidth;
			var newHeight = window.innerHeight;

			if (newWidth !== this.mvc.model.get(Enums.ParameterRoles.WIDTH)) {
			    this.mvc.model.set(Enums.ParameterRoles.WIDTH, newWidth);
				this.fireActualWidthChanged(newWidth);
			}

			if (newHeight !== this.mvc.model.get(Enums.ParameterRoles.HEIGHT)) {
			    this.mvc.model.set(Enums.ParameterRoles.HEIGHT, newHeight);
				this.fireActualHeightChanged(newHeight);
			}
		}		
    });

    function registerLoggerForObject(object, advice) {
        _.forOwn(advice[object.ClassName], function (advise, methodName) {
            meld.before(object, methodName, advise.before);
            meld.after(object, methodName, advise.after);
            meld.afterReturning(object, methodName, advise.after);
        });
    }

	return SchemeController;
});
