﻿// <copyright file="Action.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 


define(['common/Enums', 'base/Model', 'helpers/contextResolver', 'common/Error'],
    function (Enums, Model, contextResolver, Error) {

        var Event = Model.extend({

            init: function (options) {
                this._super();
                this._data = $.extend(true, {}, options.parameters);
                this.type = options.type;
                this.actions = options.actions;
                this.isTrigger = options.isTrigger;
                this.ClassName = this.type + '_event';
            },

            getType: function () {
                return this.type;
            },

            getActions: function () {
                return this.actions || [];
            },

            getIsTriggerOnlyEvent: function () {
                return this.isTrigger;
            },

            updateParameters: function (event, context) {
                switch (this.type) {
                    case Enums.EventType.mouseDown:
                    case Enums.EventType.mouseUp:
                    case Enums.EventType.mouseMove:
                    case Enums.EventType.mouseEnter:
                    case Enums.EventType.mouseLeave:
                    case Enums.EventType.click:
                    case Enums.EventType.doubleClick: {
                    //    var windowContext = contextResolver.getParentWindowControl(context);
                    //    var coords = this._getWindowCoords(windowContext, event.clientX, event.clientY);

                        this._updateParameter(Enums.EventParameters.X, event.clientX);
                        this._updateParameter(Enums.EventParameters.Y, event.clientY);
                        this._updateParameter(Enums.EventParameters.MouseLB, event.button === 0);
                        this._updateParameter(Enums.EventParameters.MouseMB, event.button === 1);
                    }
                        break;
                    case Enums.EventType.keyPress:
                    case Enums.EventType.keyDown:
                    case Enums.EventType.keyUp: {
                        this.set(Enums.EventParameters.Key, String.fromCharCode(event.which));
                        this.set(Enums.EventParameters.KeyCode, event.which);
                    }
                        break;
                    case Enums.EventType.focus:
                    case Enums.EventType.lostFocus:
                        break; //без параметров
                    case Enums.EventType.contextMenu:
                        var windowContext = contextResolver.getParentWindowControl(context);
                        var coords = this._getWindowCoords(windowContext, event.clientX, event.clientY);
                        this._updateParameter(Enums.EventParameters.X, coords.x);
                        this._updateParameter(Enums.EventParameters.Y, coords.y);
                        break;
                    default:
                        Error.onerror('Unknown event type: ' + this.type);
                        break;
                }
            },

            _updateParameter: function (name, value) {
                //force - начальное значение параметра и параметр события могут совпадать
                //но обновление связей вызвать нужно       
                var prop = this.getProperty(name);
                if (prop != null) {
                    prop.value = value;
                    this.setProperty(name, prop, false, true);
                    prop = null;
                }
            },

            _getWindowCoords: function (ctx, clientX, clientY) {
                //имеется ввиду окно в понимании редактора          
                var offset = ctx.view.$().offset();
                return {
                    x: clientX - offset.left,
                    y: clientY - offset.top
                };
            }
        });


        return Event;
    });