﻿// <copyright file="OpenWindowAction.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 


define(['core/actions/OpenDialog/OpenDialogAction'], function (OpenDialogAction) {

    var ControlFactory;

    //broke cirle dependencies
    // TODO replace with call to ModulesProvider
    curl(['controls/ControlFactory'], function (cf) {
        ControlFactory = cf;
    });

    var OpenJournalAction = OpenDialogAction.extend({
        init: function (options) {
            this._super(options);
            this.typeReplaceParams = {};
        },

        _createControl: function (windowModel, context) {
            return ControlFactory.createControl(windowModel.typeName, context.mvc.model.resourceManager, this.typeReplaceParams);
        },

        addTypeReplaceParameters: function (params) {
            $.extend(true, this.typeReplaceParams, params);
        },
        replaceModelParams: function (constToPrep) {
            this._data = this.prepareToReplace(constToPrep);
        },
        prepareToReplace: function (constants) {
            var data = {};

            data.CanMinimize = {
                typeHash: 3,
                typeName: "BOOL",
                value: constants.CanMinimize
            };
            data.CanResize = {
                typeHash: 3,
                typeName: "BOOL",
                value: constants.CanResize
            };
            data.HeaderBackgroundColor = {
                typeHash: 3,
                typeName: "HMI.SolidColorType",
                value: constants.Background
            };
            data.HeaderTextColor = {
                typeHash: 0,
                typeName: "STRING",
                value: "Red"
            };
            data.SizeToContent = {
                typeHash: 5,
                typeName: "HMI.SizeToContentType",
                value: 0
            };
            data.Text = {
                typeHash: 4,
                typeName: "STRING",
                value: constants.Title
            };
            data.Width = {
                typeHash: 3,
                typeName: "BOOL",
                value: constants.Width
            };
            data.Height = {
                typeHash: 3,
                typeName: "BOOL",
                value: constants.Height
            };

            return data;
        }
    });


    return OpenJournalAction;
});
