﻿define(['core/actions/OpenWindowAction', 'core/WindowsManager'],
    function (OpenWindowActionBase, WindowsManager) {

        var OpenPrintDialogAction = OpenWindowActionBase.extend({
            executeInternal: function (context, resolve, reject, notify) {
                var windowModel = WindowsManager.getWindowModelById(this.constants.WindowId, true);
                return window.open(String.format('?{0}={1}&{2}={3}', WindowsManager.prefix, this.constants.WindowId, WindowsManager.print, true), '', 'height=' + windowModel.parameters.Height.value + ', width=' + windowModel.parameters.Width.value);
            }
        });
        return OpenPrintDialogAction;
    });