﻿// <copyright file="OpenWindowAction.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 


define(['core/actions/OpenWindowActionBase', 'core/WindowsManager', 'helpers/contextResolver', 'common/Enums'],
    function (OpenWindowActionBase, WindowsManager, contextResolver, Enums) {

        var OpenWindowAction = OpenWindowActionBase.extend({
            init: function (options) {
                this.frame = null;
                this._super(options);
            },

            executeInternal: function (context, resolve, reject, notify) {

                //frame == null - иначе во фрейме текущее окно
                if (this.frame !== null) {
                    return;
                }

                this.askConfirmation(context, resolve, this);
            },


            allowAct: function (args) {

                var context = args.context;
                var resolve = args.resolve;
                var that = args.that;

                that._addInputParams();
                if (that.constants.Frame != null) {
                    var windowContext = contextResolver.getRootWindow(context);
                    that.frame = contextResolver.resolve(that.constants.Frame, windowContext);
                    if (!that.frame) {
                        windowContext = contextResolver.getParentWindowControl(context);
                        that.frame = contextResolver.resolve(that.constants.Frame, windowContext);
                    }
                    var windowModel = WindowsManager.getWindowModelById(that.constants.WindowId, true);

                    that._addInputParams();

                    $.extend(true, windowModel, {
                        parameters: that.replacedModelParameters
                    });

                    that.frame.controller.setWindow(windowModel, true);
                    that._bindProperties();

                    that.frame.controller.updateChildWindowSize();
                    that.frame.model.subscribePropertyChanged(that._onFrameModelPropertyChanged, that);

                    windowModel = null;
                    windowContext = null;
                    that.replacedModelParameters = {};
                    //frame = null;

                } else {
                    if (that.get('OpenNew') == true) {
                        WindowsManager.openWindowInNewTab(that.constants.WindowId);
                    } else {
                        WindowsManager.setActiveWindowModelById(that.constants.WindowId, that.replacedModelParameters);
                    }
                }

                resolve();
            },

            denyAct: function () {

            },



            _onFrameModelPropertyChanged: function (event) {
                if (event.property === Enums.ParameterRoles.DATA_SOURCE) {
                    this._retrieveOutputPrams();

                    this.frame.model.unsubscribePropertyChanged(this._onFrameModelPropertyChanged);
                    this.frame.model.unsubscribePropertyChanged(this._onWindowPropertyChanged);
                    this.unsubscribePropertyChanged(this._onModelPropertyChanged);

                    this.frame = null;
                    this.parametersChache = {
                        input: {},
                        output: {}
                    };
                }
            },

            getWindow: function () {
                return this.frame.controller.getNestedWindow();
            }
        });


        return OpenWindowAction;
    });