﻿// <copyright file="Trigger.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 


define(['common/Enums', 'base/ObservableObject', 'core/trigger/ConditionFactory'], function (Enums, ObservableObject, ConditionFactory) {
    var TRIGGER_UNDO = 'TriggerUndo';

    var Trigger = ObservableObject.extend({
        init: function (options, conditionFactory, context) {
            this._super();
            this.context = context;
            this.actions = [];
            this.conditions = [];
            this.conditionsDictionary = {}; //для быстрого доступа из changeConditioState
            this.state = false;
            this.id = options.id;

            for (var i = 0; i < options.conditions.length; i++) {
                var conditionCtor = ConditionFactory.getByType(options.conditions[i].type);
                var condition = new conditionCtor(options.conditions[i], this.conditionsDictionary, ConditionFactory);
                condition.subscribeConditionStateChanged(this.onConditionStateChanged, this);
                this.conditions.push(condition);
            }

            //this.onConditionStateChanged(); - вызовем после создания всех триггеров и обработки связей
        },

        onConditionStateChanged: function (ctx) {
            var i, newState = false;
            for (i = 0; i < this.conditions.length; i++) {
                newState = newState || this.conditions[i].getState();
            }

            if (newState == true) { //!=this.state - надо true что б применялся и поднимался вверх по блокировкам            
                this.performActions(ctx);
            } else if (this.state == true) { //только если реально откатились, т.е были в true, а стали false, а не просто не сработал
                this.fireTriggerUndo(this.id);
            }
            this.state = newState;
        },

        performActions: function () {
            for (var i = 0; i < this.actions.length; i++) {
                this.actions[i].execute(this.context);
            }
        },

        subscribeTriggerUndo: function (handler, context) {
            this.eventTarget.addListener(TRIGGER_UNDO, handler, context);
        },

        fireTriggerUndo: function (triggerId) {
            this.eventTarget.fire({ type: TRIGGER_UNDO, target: this, triggerId: triggerId });
        }
    });


    return Trigger;
})