// <copyright file="VariablesManager.js" company="">
// , 2014
// </copyright>
// 


/** 
	* @class VariablesManager
	* @classdesc Represents an object, which holds and manages state of "server variable" abstraction.
	
	*/
define(['server/VariablesManager', 'server/adapters/DataAdapter', 'common/Utilites', 'common/Enums', 'common/Error'],
    function (VariablesManager, DataAdapter, Utilities, enums, Error) {


        var ShemeVariablesManager = VariablesManager.extend({
            windowsVarsKey: "vars",

            init: function (options) {
                this._super(options);
                this.waitingWidows = [];
                this.className = 'SchemeVariablesManager';
            },

            addToSubscription: function (vars, windowId) {
                if (vars.getValues && vars.getValues.length > 0) {
                    var waitingWindow = {};
                    var waitingVariables = {};
                    waitingWindow["id"] = windowId;
                    waitingWindow[this.windowsVarsKey] = waitingVariables;
                    for (var i = 0; i < vars.getValues.length; i++) {
                        var variable = vars.getValues[i];
                        //   -   
                        //   ,     - .      
                        if (this.variables.get.schema[this.getKey(variable)] === undefined || this.variables.get.schema[this.getKey(variable)].value === undefined) {
                            waitingVariables[this.getKey(variable)] = variable;
                        }
                    }

                    this.waitingWidows.push(waitingWindow);
                }

                this._super(vars);
            },

            _initializeTimerOnCreate: function () {
                this.initialize();
                this.startTimer();
            },

            _getAllSucceed: function (recs) {
                var i;
                for (i = 0; i < recs.length; i++) {
                    //     ,    
                    var variable = this.variables.get.callback[recs[i].clientHandle];
                    if (variable !== undefined) {
                        if (Utilities.compare(variable.value, recs[i].value) == 0) {
                            continue;
                        }

                        if (this.waitingWidows.length > 0) {
                            var ctx = this;
                            _.forEach(this.waitingWidows, function (waitingWindow) {
                                if (waitingWindow[ctx.windowsVarsKey][ctx.getKey(variable)]) {
                                    delete waitingWindow[ctx.windowsVarsKey][ctx.getKey(variable)];
                                }
                            });
                        }

                        var oldvalue = variable.value;
                        variable.value = recs[i].value;
                        //console.log('Fire update: itemId:' + variable[this.keyFieldName] + ' old:' + oldvalue + ' new:' + variable.value);
                        this.firePropertyChanged(this._getVariablePropertyPath(variable), oldvalue, variable.value);
                    } else {
                        console.log('GetAllSucceed: Requested variable not found!!!!');
                    }
                }

                this._afterGetAllSucceed();
                if (recs.length) {
                    this._showErrConvertMessages(enums.errMessages);
                }

                return Promise.resolve();
            },

            _showErrConvertMessages: function (obj) {
                if (!Object.keys(obj).length) {
                    return;
                } else {
                    for (var key in obj) {
                        Error.warn(obj[key]);
                        delete obj[key];
                    }
                }
            },

            _afterGetAllSucceed: function () {
                if (this.waitingWidows.length > 0) {
                    var processedWindows = [];
                    var i;
                    for (i = 0; i < this.waitingWidows.length; i++) {
                        var waitingWindow = this.waitingWidows[i];
                        if (_.size(waitingWindow[this.windowsVarsKey]) === 0) {
                            this._serverDataReady(waitingWindow["id"]);
                            processedWindows.push(waitingWindow["id"]);
                        }
                    }

                    for (i = 0; i < processedWindows.length; i++) {
                        _.remove(this.waitingWidows, function (waitingWindow) {
                            return waitingWindow["id"] === processedWindows[i];
                        });
                    }

                    if (this.waitingWidows.length === 0) {
                        this.eventTarget.removeAllListeners(this.SERVER_DATA_READY);
                    }

                    processedWindows = [];
                }
            },

            _serverDataReady: function (id) {
                //       ,
                //    
                //console.log('ServerDataReady');
                this.fireServerDataReady(id);
            },

            unsubscribe: function (vars, objectId) {

                if (vars.getValues && vars.getValues.length > 0 && objectId) {
                    var waitingWindowIndex = _.findIndex(this.waitingWidows, function (win) {
                        return win.id === objectId;
                    });

                    if (waitingWindowIndex !== -1) {
                        var waitingWindow = this.waitingWidows[waitingWindowIndex];
                        var waitingVariables = waitingWindow[this.windowsVarsKey];

                        for (var i = 0; i < vars.getValues.length; i++) {
                            var variable = vars.getValues[i];
                            var itemId = variable[this.keyFieldName];
                            delete waitingVariables[itemId];
                        }

                        if (Object.keys(waitingVariables).length === 0) {
                            this.waitingWidows.splice(waitingWindowIndex, 1);
                        }
                    }                                     
                }


                return this._super(vars);
            }

        });

        return ShemeVariablesManager;
    });