﻿
define(['common/Enums', 'base/ContainerModel'], function (Enums, ContainerModel) {

    var TextControlModel = ContainerModel.extend({

        init: function (type, parentResourceManager) {
            this._super(type, parentResourceManager)
        },

        getText: function () {
            return this.get(Enums.ParameterRoles.TEXT);
        },

        setText: function (value) {
            this.set(Enums.ParameterRoles.TEXT, value);
        },

        getTextShadowColor: function () {
            return this.get(Enums.ParameterRoles.TEXT_SHADOW_COLOR);
        },

        getTextShadowSize: function () {
            return this.get(Enums.ParameterRoles.TEXT_SHADOW_SIZE);
        },

        getFontSize: function () {
            return this.get(Enums.ParameterRoles.FONT_SIZE);
        },

        getTextColor: function () {
            return this.get(Enums.ParameterRoles.TEXT_COLOR);
        }
    });

    return TextControlModel;

});