/** 
	* @class Error
	* @classdesc
	
	*/
define(['server/ServerLogger', 'common/Enums', 'libs/stacktrace'], function (Logger, Enums, Stacktrace) {
	/** 
	* Creates an Error object
	* @constructor
	* @this {Error}
	*/
    function Error() {
        window.onerror = function(error, url, line, column, eObj) {
            this.onerror(String.format('Error: {0} \n File: {1} \n Line: {2} Column: {3}', error,
                url, line, column));
            return true;
        }.bind(this);

        window.onexception = function (ex) {
            this.exception(ex);
            return true;
        }.bind(this);
    };
    Error.prototype.getNowString = function () {
        return (new Date()).toLocaleString();
    };
    Error.prototype.getHexFormattedErrorCode = function (code) {
        var codeHex = code.toString(16).toUpperCase();
        while (codeHex.length < 8) {
            codeHex = "0" + codeHex;
        }

        return "0x" + codeHex;
    };
    Error.prototype.onerror = function (reason) {
        var message = String.format('Reason: {0} \n Time: {1} Stack trace: \n {2}', reason, this.getNowString(),
            (new Stacktrace()).join('\n'));
        console.error(message);
        Logger.logMessage(message, Enums.logLevel.error);
        return message;
	}

    Error.prototype.exception = function (e) {
        if (e && e.status !== undefined && e.data !== undefined) {
            e.message =  String.format('{0} code: {1} status: {2}', e.data.message, this.getHexFormattedErrorCode(e.data.code), e.status);            
        } else {
            e = e || {
                message: 'Undefined exception',
                stack: ''
            };
        }
        var message = String.format('Reason: {0} \n Stack trace: \n {1}', e.message || e,
           e.stack);
        console.error(message, this.getNowString());
        Logger.logMessage(message, Enums.logLevel.error, e.data);
        return message;
	}

	Error.prototype.warn = function (reason) {
	    console.warn(reason, this.getNowString());
	    Logger.logMessage(reason, Enums.logLevel.waring);
	    return reason;
	}

	Error.prototype.debug = function (reason) {
        //IE 10
	    console.debug !== undefined ? console.debug(reason) : console.log(reason);
	    Logger.logMessage(reason, Enums.logLevel.debug);
	    return reason;
	}

	Error.prototype.info = function (reason) {
	    console.info(reason, this.getNowString());
	    Logger.logMessage(reason, Enums.logLevel.info);
	    return reason;
	}
	var instance = new Error();
	return instance;
});