﻿// <copyright file="ButtonController.js" company="ИнСАТ">
// ИнСАТ, 2016
// </copyright>

define(['common/Enums', 'common/Appearence', 'base/TextControlController'], function (Enums, Appearence, TextControlController) {
    var coefficients = { //ax+b
        upA: 1,
        upB: 0,
        downA: 1.25,
        downB: 100,
        overA: 1.1,
        overB: 25
    }
    var ButtonController = TextControlController.extend({
        init: function () {
            this._super();
            this.ClassName = 'ButtonController';
            this.modelChanged[Enums.ParameterRoles.IS_PRESSED] = this.onPressedChanged.bind(this);
            this.modelChanged[Enums.ParameterRoles.BORDER_COLOR] = this.onBorderChanged.bind(this);
            this.modelChanged[Enums.ParameterRoles.BORDER_THIKNESS] = this.onBorderChanged.bind(this);
            this.modelChanged[Enums.ParameterRoles.BORDER_STYLE] = this.onBorderChanged.bind(this);
            this.modelChanged[Enums.ParameterRoles.BACKGROUND_COLOR] = this.onBackgroundColorChanged.bind(this);
            this.modelChanged[Enums.ParameterRoles.IS_FIXED] = this.onIsFixedChanged.bind(this);
            this.modelChanged[Enums.Button.State] = this.onButtonStateChanged.bind(this);
            this.modelChanged[Enums.ParameterRoles.SHADOW_COLOR] = this.onShadowChanged.bind(this);
            this.modelChanged[Enums.ParameterRoles.SHADOW_SIZE] = this.onShadowChanged.bind(this);
        },
        onAddedToDOM: function () {
            this._super();
            if (this.mvc.model.get(Enums.ParameterRoles.SKIN)) {
                this.modelChanged[Enums.Button.State] = this.onSvgButtonStateChanged.bind(this);
            }
            this.isCovered = false;
            this.calculateFontSizeRatio();
            this.applyFontSize();
            this.onPressedChanged(this.mvc.model.getIsPressed());

            var isTouch = this.isTouchDevice();
            if (isTouch) {
                this.mvc.view.$().off('mouseenter');
                this.mvc.view.$().off('mouseleave');
                this.mvc.view.$().off('mouseup');
                this.mvc.view.$().off('mousedown');
            }
            if (this.mvc.model.get(Enums.ParameterRoles.IS_FIXED)) {
                this.doOnMouseDown = this.switchPress;
                this.doOnMouseUp = function () { };
                this.doOnMouseLeave = function () { };
            } else {
                this.doOnMouseDown = this.press;
                this.doOnMouseUp = this.unpress;
                this.doOnMouseLeave = this.unpress;
                this.mvc.model.setIsPressed(false);
            }
        },

        onBackgroundColorChanged: function (value) {
            Appearence.background.apply(this.mvc.view.$(), value);
            this.onShadowChanged();
        },
        
        onSvgButtonStateChanged: function (state) {
            switch (this.getButtonState()) {
            case Enums.Button.Up:
                this.onSvgModelChanged("down:display:style", null, "none");
                this.onSvgModelChanged("over:display:style", null, "none");
                this.onSvgModelChanged("up:display:style", null, "inline");
                break;
            case Enums.Button.Down:
                this.onSvgModelChanged("down:display:style", null, "inline");
                this.onSvgModelChanged("over:display:style", null, "none");
                this.onSvgModelChanged("up:display:style", null, "none");
                break;
            case Enums.Button.Over:
                this.onSvgModelChanged("down:display:style", null, "none");
                this.onSvgModelChanged("over:display:style", null, "inline");
                this.onSvgModelChanged("up:display:style", null, "none");
                break;
            }
        },

        getButtonState: function () {
            if (this.mvc.model.getIsPressed()) {
                return Enums.Button.Down;
            }
            else
            if (this.isCovered) {
                return Enums.Button.Over;
            }
            else {
                return Enums.Button.Up;
            }
        },

        isTouchDevice: function () {
            return !!('ontouchstart' in window);
        },

        onIsFixedChanged: function (value) {            
        },
        onBorderChanged: function () {
            if (this.mvc.model.getBorderStyle() != Enums.BorderStyleType.Solid) {
                this.applyBorder();
                return;
            }
            if (this.mvc.model.getIsPressed()) {
                this.mvc.view.$().css('border-width', this.mvc.model.getBorderThickness());
                this.mvc.view.$().css('border-style', 'inset');
                this.mvc.view.$().css('border-color', this.mvc.model.getBorderColor());
            }
            else {
                this.mvc.view.$().css('border-width', this.mvc.model.getBorderThickness());
                this.mvc.view.$().css('border-style', 'outset');
                this.mvc.view.$().css('border-color', this.mvc.model.getBorderColor());
            }
        },
        onPressedChanged: function (value) {
            this.modelChanged[Enums.Button.State]();
            this.modelChanged[Enums.ParameterRoles.BORDER_STYLE](value);
        },

        allowAct: function() {
            if (Enums.ParameterRoles.IS_FIXED)
                this.mvc.model.setIsPressed(!(this.mvc.model.getIsPressed()));
            return Promise.resolve();
        },

        textElement: function () {
            return this.mvc.view.$();
        },

        onButtonStateChanged: function (state) {
            if (this.mvc.model.get(Enums.ParameterRoles.IS_FIXED)) {
                switch (this.getButtonState()) {
                    case Enums.Button.Up:
                        this.onBackgroundColorChanged(this.mvc.model.getBackgroundColor());
                        this.onBorderChanged();
                        this.onTextColorChanged(this.mvc.model.get(Enums.ParameterRoles.TEXT_COLOR));
                        break;
                    case Enums.Button.Down:
                        this.onBackgroundColorChanged(Appearence.background.calculateColor(this.mvc.model.getBackgroundColor(), coefficients.downA, coefficients.downB));
                        this.onBorderChanged();
                        this.onTextColorChanged(this.mvc.model.get(Enums.ParameterRoles.TEXT_COLOR));
                        break;                   
                }
            }
        },
        attachEvents: function (elem) {
            this._super(elem);
            var self = this;
            elem.on("mousedown touchstart",
                function (event) {
                    self.onMouseDown(event);
                });
            elem.on("mouseup touchend touchcancel",
                function (event) {
                    self.onMouseUp(event);
                });
            elem.mouseenter(function (event) { self.onMouseEnter(event); });
            elem.mouseleave(function (event) { self.onMouseLeave(event); });
        },
        onMouseDownNotFixed: function (event) {
            this.mvc.model.setIsPressed(true);
            this._super(event);
        },
        unpress: function (event) {
            this.mvc.model.setIsPressed(false);
        },
        press: function(event){
            this.mvc.model.setIsPressed(true);
        },
        switchPress: function (event) {
            this.askConfirmation();
        },
        onMouseUp: function (event) {
            this.doOnMouseUp();
            this.modelChanged[Enums.Button.State]();
        },
        onMouseDown: function (event) {
            this.doOnMouseDown();
            this.modelChanged[Enums.Button.State]();
        },
        onMouseEnter: function (event) {
            this.isCovered = true;
            this.modelChanged[Enums.Button.State]();
        },
        onMouseLeave: function (event) {
            this.doOnMouseLeave();
            this.isCovered = false;
            this.modelChanged[Enums.Button.State]();
        },

        onRender: function () {

        }
    });
    return ButtonController;
});