﻿// <copyright file="ComboBoxController.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 


/*
* @class ComboBoxController controller class for ComboBox control
*/
define(['common/Enums', 'common/Appearence', 'base/TextControlController', 'common/Error'],
function (Enums, Appearence, TextControlController, Error) {
    //here we will define controller for button

    var ComboBoxController = TextControlController.extend({

        init: function () {
            this._super();

            this.ClassName = 'ComboBoxController';
            this.isAddedToDom = false;
            this.Itemlist = [];
        },

        onModelInit: function () {
            this._super();

            this.fillDropdown();
        },

        onAddedToDOM: function () {
            this._super();

            //пустая строка возможна только при пустом поле Выбор
            if (this.mvc.model.getSelectedValue() === "") {
                this.mvc.view.$().prop("selectedIndex", -1);
            } else {
                this.mvc.view.$().val(this.mvc.model.getSelectedValue());
            }

            this.isAddedToDom = true;
        },        

        fillDropdown: function () {
            var items = this.mvc.model.getItems();
            var i,
                item,
                tmpItems,
                options = [],
                option;

            if (!items) {
                return;
            }

            if (typeof items === 'string') {
                tmpItems = items.split('~');
                items = [];
                for (i = 0; i < tmpItems.length; i++) {
                    if (tmpItems[i] !== '') {
                        items.push({ value: tmpItems[i], text: tmpItems[i] });
                    }
                }
            }

            this.Itemlist = items;

            if (!items.length) {
                return;
            }

            for (i = 0; i < items.length; i++) {
                item = items[i];

                option = $(document.createElement('option'));
                option.attr('value', item.value);
                option.text(item.text || item.value);

                options.push(option);
            }

            this.mvc.view.$().append(options);          

            var color = Appearence.background.getSingleColor(this.mvc.model.getBackgroundColor());

            this.mvc.view.$('option').css('background-color', color);
        },

        textElement: function () {
            return this.mvc.view.$();
        },

        displayText: function () {
            //do nothing
        },

        modelPropertyChangedInternal: function (event) {
            //close select
            this.mvc.view.$().blur();

            this._super(event);

            var value = this.mvc.model.get(event.property);

            switch (event.property) {
                case Enums.ParameterRoles.SELECTED_ITEM:
                    this.onSelectedItemChanged(value);
                    break;
                case Enums.ParameterRoles.ITEM_SOURCE:
                    this._onItemSourceChanged();
                    break;
            }
        },

        validateProperty: function (propertyName, newProperty) {
            switch (propertyName) {
                case Enums.ParameterRoles.SELECTED_ITEM:
                    this._validateSelectedItem(propertyName, newProperty);
                    break;
            }
        },

        _validateSelectedItem: function (propertyName, newProperty) {

            var findResult = _.find(this.Itemlist, function (item) {
                return newProperty.value === item.value;
            });

            if (findResult === undefined) {
                Error.warn(String.format('Control: {0} Property: {1} Selected value {2} is not in list. Value will be set to empty.',
              this.mvc.model.getId(), propertyName, newProperty.value));
                newProperty.value = '';
            }
        },

        _onItemSourceChanged: function () {
            this.mvc.view.$().find('option').remove().end();
            this.fillDropdown();
            this.mvc.view.$().val('');
            this.mvc.view.$().prop("selectedIndex", -1);
        },

        onSelectedItemChanged: function (value) {        
            this.mvc.view.$().val(value);
        },

        onBackgroundColorChanged: function (value) {
            this._super(value);
            this.onShadowChanged();
            //apply bg to options
            var color = Appearence.background.getSingleColor(value);      
            this.mvc.view.$().css('background-color', color);
        },
        attachEvents: function (elem) {
            this._super(elem);
            var self = this;
            elem.change(function (event) { self.onChange(event) });
        },

        onChange: function (event) {
            if (this.isAddedToDom) {
                this.mvc.model.setSelectedValue(this.mvc.view.$().val());
            }
        },

        onActualFontSizeChanged: function () {
            this._super();
            this.mvc.view.$().blur();
        },
        onRender: function () {

        }
    });

    return ComboBoxController;
});
