﻿define(['core/L10n'], function (L10n) {

    var rowTemplate = function (text, level, levelClass) {
        return $$({
            view: {
                format: String.format('<tr class="{0}"><td align="left" class="msg-td">{1}</td><td align="left" >{2}</td></tr>', levelClass, level, text)
            }
        });
    }


    var ErrorsPopupController = Class.extend({

        maxMessagesCount:50,
        
        levelClass: {
            "32" : "msg-error",
            "16" : "msg-warn",
            "4": "msg-info",
            "2": "msg-debug"
        },

        options: {
            resizable: true,
            collapseEnabled: true,
            width: 500,
            height: 200,
            dialogClass: "error-dialog",
            setWidth: true,
            setMinHeight: false,
            hide: true
        },

        open: function () {
            if (!this._opened) {
                var that = this;
                this.options.title = L10n.get('messages.errorsWindowTitle');
                this.options.close = function (event, ui) {
                    that._opened = false;
                    $(this).dialog('destroy').remove();
                };

                this.mvc.view.$().dialog(this.options);               
                this._opened = true;
            }
        },

        addMessage: function (msg) {
            if (msg.message !== undefined) {
                if (!(msg.message instanceof String)) {
                    msg.message = JSON.stringify(msg.message);
                }

                this.mvc.append(rowTemplate(msg.message,
                    L10n.get('messages.messageLevel.' + msg.level), this.levelClass[msg.level]), 'table');

                var keys = Object.keys(this.mvc._container.children);
                if (keys.length > this.maxMessagesCount) {
                    this.mvc._container.children[keys[0]].destroy();
                }
            }         

            //if (!this._opened) {
            //    this.open();
            //    this._opened = true;
            //}
        },        

        //Alex: to let know agility to not make proxy for models
        _noProxy: function () { },
        
    });

    return ErrorsPopupController;
})