﻿// <copyright file="GeometryModel.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>

define(['common/Enums', 'base/ContainerModel', 'common/GeometryNormalizer/GeometryNormalizer'],
    function (Enums, ContainerModel, GeometryNormalizer) {
    return ContainerModel.extend({

        init: function (type, parentResourceManager) {
            this._super(type, parentResourceManager);

            this.ClassName = 'GeometryModel';
        },

        getGeometry: function(parentWidth, parentHeight) {
            if (this.get(Enums.ParameterRoles.BORDER_GEOMETRY) === "OVAL" ||
                this.get(Enums.ParameterRoles.BORDER_GEOMETRY) === "RECT") {
                return GeometryNormalizer.normalize(this.get(Enums.ParameterRoles.BORDER_GEOMETRY),
                    this.get(Enums.ParameterRoles.WIDTH),
                    this.get(Enums.ParameterRoles.HEIGHT),
                    parentWidth,
                    parentHeight);
            } else {
                return this.get(Enums.ParameterRoles.BORDER_GEOMETRY);
            }
        }
    });
});