﻿// <copyright file="GridHelper.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

define(['common/Appearence', 'core/ImplicitConvertations'], function (Appearence, ImplicitConvertations) {

    var properties = {
        RowHeight: 'height',
        Height: 'height',
        BorderThickness: 'borderWidth',
        BorderColor: 'borderColor',
        BorderStyle: 'borderStyle',
        BackgroundColor: 'background-color',
        LegendBackgroundColor: 'background-color',
        ToolbarBackgroundColor: 'background-color',
        FiltersBackgroundColor: 'background-color',
        FontName: 'font-family',
        FontSize: 'font-size',
        TextColor: 'color',
        HorizontalAlignment: 'align',
        FontItalic: 'font-style',
        FontBold: 'font-weight',
        FontUnderlined: 'text-decoration',
        TextVerticalAlign: 'valign'
    };

    var convertModelPropertyToCssProperty = function (propertyName) {
        if (properties.hasOwnProperty(propertyName)) {
            return properties[propertyName];
        } else {
            return null;
        }
    };

    function GridHelper() {
    };
     

    GridHelper.prototype.updateStyles = function (styles, message, convertationsCache) {
        var cssObj = {};
        for (var style in styles) {
            var cssProp = convertModelPropertyToCssProperty(style);
            if (cssProp === null) {
                console.log('no property ' + style);
                continue;
            }

            var value = styles[style].value;
            if(message && convertationsCache && styles[style].metadata){
                if(styles[style].metadata.Field != null){
                    var fieldVal = message[styles[style].metadata.Field];
                    if (fieldVal == undefined) {
                        console.log('Невозможно извлечь значение поля ' + styles[style].metadata.Field + ' из сообщения ' + message.Message);
                        continue;
                    }
                    if (convertationsCache[style] == undefined) {
                        console.log('Не задана конвертация для свойства ' + style + ' для поля ' + fieldVal + 'в журнале');
                        continue;
                    }
                    value = convertationsCache[style].convert(fieldVal, null);
                }

            }

            switch(style){               
                case "BorderColor":
                case "TextColor":
                    cssObj[cssProp] = Appearence.color.toCssColor(value);
                    break;
                case "BackgroundColor":
                    //gradient, apply with appearence
                    cssObj[style] = value;
                    break;
                case "FontBold":
                    cssObj[cssProp] = value ? 'bold' : '';
                    break;
                case "FontUnderlined":
                    cssObj[cssProp] = value ? 'underline' : '';
                    break;
                case "FontItalic":
                    cssObj[cssProp] = value ? 'italic' : '';
                    break;
                default:
                    cssObj[cssProp] = value;
                    break;
            }            
        }
        
        if (cssObj[properties.Height] !== undefined) {
            cssObj[properties.Height] = (cssObj[properties.Height] === 0) || (cssObj[properties.Height] &&
                 cssObj[properties.Height].toLowerCase && cssObj[properties.Height].toLowerCase() === 'auto') ?
              cssObj[properties.FontSize] + 4 : cssObj[properties.Height];
        }

        return cssObj;
    };
    
    GridHelper.prototype.getColumnsStyles = function (columns, tableWidth, messages) {
        var columnStyles = [];       
        var starswidth = tableWidth;
        var starscount = 0;

        _.forEach(columns, function (column) {

            var columnStyle = {
                width: column.width,
                display: column.visibility ? '' : 'none',
                type: '',
                align: column.align
            };

            if (!column.visibility) {
                columnStyles.push(columnStyle);
                return;
            }

            if (column.width.indexOf("%") != -1) {
                starswidth = starswidth - ((parseFloat(column.width) / 100) * tableWidth);
            } else if (column.width.indexOf("*") != -1) {
                if (column.width == "*")
                    starscount++;
                else
                    starscount += parseFloat(column.width);
            } else if (column.width.indexOf("Auto") != -1) {
                var columnWidth = getColumnAutoWidth(column, messages);
                starswidth -= columnWidth;
                columnStyle.width = column.width;
            } else {
                starswidth = starswidth - parseInt(column.width, 10);
                columnStyle.width = column.width;
                columnStyle.type = 'px';
            }

            columnStyles.push(columnStyle);
        });

        var widthforstar = 0;
        if (starscount != 0) {
            widthforstar = starswidth / starscount;
        }

        columnStyles.forEach(function (columnStyle) {
            // parseFloat для * вернет NaN, для 2* - 2
                if (columnStyle.width.indexOf("*") != -1) {
                    columnStyle.width = Math.floor(
                        (100 * widthforstar *
                        (isNaN(parseFloat(columnStyle.width)) ? 1 : parseFloat(columnStyle.width))
                        ) / tableWidth) + '%';
                }
            });

        return columnStyles;
    };

    function getColumnAutoWidth(column, messages) {
        var fragment = document.createDocumentFragment();
        var contatiner = document.createElement('div');
        contatiner.style.position = 'absolute';
        var div = document.createElement('div');
        var text = document.createTextNode(column.name);
        div.appendChild(text);
        contatiner.appendChild(div);

        //для только созданного заголовка сообщений не будет
        if (messages && messages.length > 0) {
            //чем длинее текст - тем длинее div
            //ренедерить дорого, сначали ищем по длине текста
            var maxLength = 0; //колонки могут быть null, а сравнивать с чем-то надо
            var maxIndex = 0;
            for (var i = 0; i < messages.length; i++) {
                if (messages[i][column.field] != null && messages[i][column.field].length > maxLength) {
                    maxIndex = i;
                    maxLength = messages[i][column.field].length;
                }
            }

            if (messages[maxIndex][column.field] != null) {
                div = document.createElement('div');
                text = document.createTextNode(messages[maxIndex][column.field]);
                div.appendChild(text);
                contatiner.appendChild(div);
            }
        }

        fragment.appendChild(contatiner);
        document.body.appendChild(fragment);
        var width = contatiner.clientWidth;
        document.body.removeChild(contatiner);
        return width;
    };


    GridHelper.prototype.formatMessage = function (message, columns) {
        if (!columns)
            return message;

        var formatedMessage = {};

        // не удаляем не отображаемые поля - на них может быть биндинг в конвертациях
        $.extend(formatedMessage, message);

        for (var i = 0; i < columns.length; i++) {
            if (message[columns[i].field] != null) {
                if (columns[i].formatString) {
                    formatedMessage[columns[i].field] = String.format(columns[i].formatString, message[columns[i].field]);
                } else {
                    if (message[columns[i].field] instanceof Date) {
                        formatedMessage[columns[i].field] = String.format(ImplicitConvertations.getDateTimeDefaultFormat(), message[columns[i].field]);
                    } else {
                        formatedMessage[columns[i].field] = message[columns[i].field];
                    }
                }
            }
            else {
                // не удаляем не отображаемые поля - на них может быть биндинг в конвертациях
                formatedMessage[columns[i].field] = message[columns[i].field];
            }
        }

        return formatedMessage;
    };

    return new GridHelper();
});