﻿// <copyright file="LabelController.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 


/*
* @class LabelController controller class for Label control
*/
define(['common/Enums', 'base/TextControlController', 'common/Appearence', 'common/Error'], function (Enums, TextControlController, Appearence, Error) {
    //here we will define controller for button

    var LabelController = TextControlController.extend({

        init: function () {
            this._super();

            this.modelChanged[Enums.ParameterRoles.SHADOW_SIZE] = this.onShadowChanged.bind(this);
            this.modelChanged[Enums.ParameterRoles.SHADOW_COLOR] = this.onShadowChanged.bind(this);

            this.ClassName = 'LabelController';
        },

        displayText: function () {
            try {
                var text = this.mvc.model.getDisplayValue();
            }
            catch (err) {
                if (err.name === 'numberFormatError') {
                    Error.warn(err.message);
                    text = err.result;
                } else {
                    throw err;
                }
            }
            text = text != undefined ? text : "";
            this.textElement().text(text);
        },
        modelPropertyChangedInternal: function (event) {

            this._super(event);

            var value = this.mvc.model.get(event.property);

            switch (event.property) {
                case Enums.ParameterRoles.VALUE_FORMAT:
                    this.onValueFormatChanged(value);
                    break;
            }
        },

        onValueFormatChanged: function (value) {
            this.displayText();
        },

        onFontMultilineChanged: function (value) {
            var isMultiLine = this.mvc.model.get(Enums.ParameterRoles.FONT_MULTILINE);
            if (isMultiLine === true) {
                this.textElement().css('white-space', 'pre-wrap');
            } else {
                this.textElement().css('white-space', 'nowrap');
            }
        },

        onRender: function () {

        }
    });

    return LabelController;
});
