﻿// <copyright file="MarkController.js" company="ИнСАТ">
// ИнСАТ, 2016
// </copyright>

define(['common/Enums', 'common/Appearence', 'common/Utilites', 'base/ControlController', 'helpers/PermissionChecker'], function (Enums, Appearence, Utilites, ControlController, PermissionChecker) {

    var MarkController = ControlController.extend({
        init: function () {
            this._super();
            this.ClassName = 'MarkController';
            this.marks = [];
            this.modelChanged[Enums.ParameterRoles.MARKS] = this.onMarksChanged.bind(this);
        },

        onMouseDown: function () {
            this._super();
            var new_mark = this.mvc.view.$().clone(false);
            var parent_el = this.mvc.view.$()[0].parentElement;
            parent_el.appendChild(new_mark[0]);
            this.startDrag(new_mark[0]);
            var marks = this.marks;
            var model = this.mvc.model;
            new_mark[0].onmouseup = function (e) {
                document.onmousemove = null;
                $(this).tooltip({
                    track: true
                });
                var message = "Пользователь " + PermissionChecker.currentOperator;
                this.setAttribute('title', message);
                marks.push({ message: message, x: this.style.left, y: this.style.top });
                model.set(Enums.ParameterRoles.MARKS, JSON.stringify(marks));
                parent_el.removeChild(this);
                this.onmouseup = null;
            }
        },
        startDrag: function(new_mark){
            document.onmousemove = function (e) {
                new_mark.style.left = e.pageX - new_mark.offsetWidth / 2 + 'px';
                new_mark.style.top = e.pageY - new_mark.offsetHeight / 2 + 'px';
            };
        },

        onMarksChanged: function () {
            var marksstring = this.mvc.model.get(Enums.ParameterRoles.MARKS);
            if (marksstring && Utilites.isJSON(marksstring)) {
                this.marks = JSON.parse(this.mvc.model.get(Enums.ParameterRoles.MARKS));
                for (var i = 0; i < this.marks.length; i++) {
                    var new_mark = this.mvc.view.$().clone(false);
                    new_mark[0].style.left = this.marks[i].x;
                    new_mark[0].style.top = this.marks[i].y;
                    this.mvc.view.$()[0].parentElement.appendChild(new_mark[0]);
                    new_mark[0].setAttribute('title', this.marks[i].message);
                }
            }
        }
    });
    return MarkController;
});