﻿// <copyright file="SchemePreloader.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

define(['common/Enums', 'core/global/GlobalEvents', 'controls/Scheme/SchemeType'], function (Enums, GlobalEvents, SchemeType) {

    var SchemePreloader = Class.extend({
        init: function () {
            this.canHide = true;
            GlobalEvents.addListener(Enums.GlobalEventsTypes.resourceFetched, this.onResourceFetched, this);
            this.typesCount = _.find(SchemeType.parameters, function (p) {
                return p.role === Enums.ParameterRoles.TYPES_COUNT
            }).defaultValue;

            this.uniqueTypesCount = _.find(SchemeType.parameters, function (p) {
                return p.role === Enums.ParameterRoles.UNIQUE_TYPES_COUNT
            }).defaultValue;

            //wire - 41, core - 38, helpers - 3
            //base - 22, common - 3, server - 7
            // this.uniqueTypesCount - т.е Controller + Model для типа
            // + 2*на каждый тип (control + type)
            // + control/Types + jquery            
            this.filesCount = this.uniqueTypesCount * 2 + this.typesCount * 2
                + 109 + 7;
            this.progress = 0;
            this.totalCount = this.filesCount;

            this._createPreloader();
        },

        onResourceFetched: function (event) {               
            this.updateProgress(1);
        },
        
        allowHide: function(canHide){
            this.canHide = canHide;
        },

        hide: function () {
            if (this.canHide === true) {
                this.preloader.hide();
            }
        },

        show: function () {
            this.preloader.show();
        },

        reset: function (totalCount) {
            this.totalCount = totalCount;
            this.progress = 0;
        },

        _update: function () {
            var percent;
            var completed = this.progress > this.totalCount ? this.totalCount : this.progress;
            this.totalCount ?
                percent = 100 * completed / this.totalCount :
                percent = 0;
            var nRadians = (360 * percent) / 100;
            this._resetCircle();           
            this._transformCircle(nRadians, this.circleDiv);
            this.circleSpan.text(String.format('{0:f0}%',
               Math.round(percent)));
        },

        _resetCircle: function () {
            this.circleSlice.show();
            this.circleSpan.text('');
            this.circleSlice.removeClass('clipauto')
            this._transformCircle(20, this.circleDiv);
            this._transformCircle(20, this.circleFill);
        },

        _transformCircle: function (nRadians, cDiv) {
            var rotate = "rotate(" + nRadians + "deg)";
            cDiv.css({
                "-webkit-transform": rotate,
                "-moz-transform": rotate,
                "-ms-transform": rotate,
                "-o-transform": rotate,
                "transform": rotate
            });
            if (nRadians > 180) {
                this._transformCircle(180, this.circleFill);
                this.circleSlice.addClass(' clipauto ');
            }
        },


        updateProgress: function (value) {
            this.progress += value;
            this._update();
        },

        _createPreloader: function () {
            this.preloader = $('<div class="preloaderBase sheme-preloader">' +
            '<div class="sheme-preloader-centered"><div class="sheme-preloader-circle">' +
            '	<div class="percenttext"> </div>' +
            '	<div class="slice">' +
            '		<div class="bar"> </div>' +
            '		<div class="fill"> </div>' +
            '	</div>' +
            '	<div class="after"> </div>' +
            ' </div>' +
            '</div>' + 
            '</div>');


            this.progCirc = this.preloader.find('.sheme-preloader-circle');            
            this.circleDiv = this.progCirc.find('.bar');
            this.circleSpan = this.progCirc.children('.percenttext');
            this.circleFill = this.progCirc.find('.fill');
            this.circleSlice = this.progCirc.find('.slice');

            var thicknessConstant = 0.02;
            var border = (5 * thicknessConstant) + 'em';
            var offset = (1 - thicknessConstant * 5 * 2) + 'em';

            this.progCirc.find(' .slice > div ').css({
                'border-width': border,
                'width': offset,
                'height': offset
            })
            this.progCirc.find('.after').css({
                'top': border,
                'left': border,
                'width': offset,
                'height': offset
            })

            
            $(document.body).append(this.preloader);
        }        
    });

    var instance = new SchemePreloader();

    return instance;
});