﻿// <copyright file="ScreenController.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

define(['common/Enums', 'common/Error', 'controls/DockPanel/DockPanelController',
    'core/WindowsManager'],
    function (Enums, Error, DockPanelController, WindowsManager) {

    var ScreenController = DockPanelController.extend({

        init: function () {
            this._super();
            this.ClassName = 'ScreenController';           
        },

        addTypeChildControls: function () {
            this._super();            
            this.onActiveWindowModelChanged({ newWindowModel: WindowsManager.getActiveWindowModel() }, false);
            WindowsManager.subscribeActiveWindowModelChanged(this.onActiveWindowModelChanged, this);
        },

        onActiveWindowModelChanged: function (event, subscribe) {
            var frame = this._getFrameContainer();
            if (!frame) {
                Error.onerror('Screen container not found.');
                return;
            }

            frame.controller.setWindowById(event.newWindowModel.parameters.Id.value, subscribe !== false);
        //    frame.controller._onParentSizeChanged(); //this._onParentSizeChanged(); updateChildWindowSize()
        },

        childModelPropertyChangedInternal: function (event) {
            this._super(event);

            switch (event.property) {
                case Enums.ParameterRoles.IS_VISIBLE:
                    this.onChildVisibilityChanged(event);
                    break;
            }
        },

        onChildVisibilityChanged: function (event) {       
            var childIndex = this.childIndexById(event.target.getId());
            var childControl = this.orderedControls[childIndex];

            if (childControl.controller.ClassName === 'TaskBarController') {
                this.repositionControls(childIndex);
            }            
        },

        _skipControl: function (childControl) {
            return childControl.controller.ClassName === 'TaskBarController'
                && !childControl.model.get(Enums.ParameterRoles.IS_VISIBLE);
        },

        _getFrameContainer: function () {
            return _.find(this.controls, function (control) {
                return control.controller.ClassName === "FrameController";
            });
        },

        onParentResized: function () {
        }
    });

    return ScreenController;
});
