﻿// <copyright file="StackPanelModel.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

/*
* @class StackPanelModel model class for StackPanel control
*/
define(['common/Enums', 'base/ContainerModel'],
function (Enums, ContainerModel) {

    var StackPanelModel = ContainerModel.extend({

        init: function (type, parentResourceManager) {
            this._super(type, parentResourceManager);

            this.ClassName = 'StackPanelModel';
        },

        getOrientation: function () {
            return this.get(Enums.ParameterRoles.ORIENTATION);
        },

        getHorizontalElementsAlign: function () {
            return this.get(Enums.ParameterRoles.HORIZONTAL_ELEMENTS_ALIGN);
        },

        getVerticalElementsAlign: function () {
            return this.get(Enums.ParameterRoles.VERTICAL_ELEMENTS_ALIGN);
        }
    });

    return StackPanelModel;
});
