﻿define(['common/Enums', 'base/ControlController', 'libs/svg/jquery_svg_drawing'], function (Enums, WindowController, svgApi) {

    var TruncatedToreController = WindowController.extend({

        init: function (statisticId) {
            this._super(statisticId);
            this.ClassName = 'TruncatedToreController';
            this.modelChanged[Enums.ParameterRoles.BACKGROUND_COLOR] = this.onFillColorChanged.bind(this);
            this.modelChanged[Enums.ParameterRoles.INITIAL_ANGLE] = this.onResize.bind(this);
            this.modelChanged[Enums.ParameterRoles.FINAL_ANGLE] = this.onResize.bind(this);
            this.modelChanged[Enums.ParameterRoles.CUT_THICKNESS] = this.onResize.bind(this);
            this.modelChanged[Enums.ParameterRoles.CUT_COLOR] = this.onResize.bind(this);
        },

        onAddedToDOM: function () {
            this._super();
            this.mvc.view.$().css('border', 'none');
            this.appendTruncatedTore();
        },

        appendTruncatedTore: function () {
            //var controlHeigthPx = this.mvc.model.getHeight();
            //var controlWidthPx = this.mvc.model.getWidth();
            var clientId = this.clientId();
            this.mvc.view.$().attr('id', clientId);
            var svg = svgApi.getSVG(clientId);
            svg.configure({ viewBox: "0 0  300 300" }, false);
            this.svgRoot = svg;
            this.createTruncatedTore(svg);
            var azimut = this.mvc.model.get(Enums.ParameterRoles.INITIAL_ANGLE);
            this.mvc.view.$().css("transform", "rotate(" + azimut + "deg)");
            this.mvc.view.$().css('width', '100%');
            this.mvc.view.$().css('height', '100%');
        },

        createTruncatedTore: function (svg) {
            var segment = document.createElementNS('http://www.w3.org/2000/svg', 'path');
            var initAngle = this.mvc.model.get(Enums.ParameterRoles.INITIAL_ANGLE);
            var finalAngle = this.mvc.model.get(Enums.ParameterRoles.FINAL_ANGLE);
            var sectorAngleDeg = finalAngle - initAngle;      //0-359.999
            if (sectorAngleDeg < 0) sectorAngleDeg = 0;
            if (sectorAngleDeg % 360 == 0) sectorAngleDeg = sectorAngleDeg - 0.001;
            sectorAngleDeg = sectorAngleDeg % 360;
            var flags = this.getQuadrantFlags(sectorAngleDeg);
            var sectorAngleRad = flags.roundAngle / 180 * Math.PI;
            var outerRadius = this.mvc.model.get(Enums.ParameterRoles.RADIUS);
            var tubeDiam = this.mvc.model.get(Enums.ParameterRoles.TUBE_DIAMETER);

            //var modelHoleRadius = this.mvc.model.get(Enums.ParameterRoles.HOLE_RADIUS);
            //var outerRadius = (flags.xf && !flags.yf) ? height : height / 2;
            var holeRadius = outerRadius - tubeDiam; // (flags.xf && !flags.yf) ? 2 * modelHoleRadius : modelHoleRadius;
            var dRad = outerRadius - holeRadius;

            var cutColor = this.mvc.model.get(Enums.ParameterRoles.CUT_COLOR);
            var cutThick = this.mvc.model.get(Enums.ParameterRoles.CUT_THICKNESS);
            //cutThick = (flags.xf && !flags.yf) ? 2 * cutThick : cutThick;

            if (holeRadius >= outerRadius) {
                dRad = 0;
                holeRadius = outerRadius;
            };

            outerRadius = outerRadius - cutThick;
            dRad = dRad - 2 * cutThick;

            holeRadius = holeRadius + cutThick;
            var startPointX = flags.xf ? 0 : outerRadius + cutThick;

            var outerAnglePoint = this.calcTrig(flags, sectorAngleRad, outerRadius);
            var innerAnglePoint = this.calcTrig(flags, sectorAngleRad, holeRadius);

            var point1 = {
                x: startPointX,
                y: cutThick
            };
            var point2 = {
                x: outerAnglePoint.x + startPointX,
                y: outerAnglePoint.y + outerRadius + cutThick,
            };
            var point3 = {
                x: innerAnglePoint.x + startPointX,
                y: innerAnglePoint.y + outerRadius + cutThick,
            };
            var point4 = {
                x: startPointX,
                y: dRad + cutThick
            };
            var id = svg._container.id;
            var overPiFlag = flags.xf ? 0 : 1;
            var segmentPathMainArc = `M${point1.x} ${point1.y} A${outerRadius} ${outerRadius}, ${0}, ${overPiFlag}, 1, ${point2.x} 
            						${point2.y}`;
            var segmentPathLine = ` L${point3.x} ${point3.y}`;
            var segmentPathInnerArc = ` A${holeRadius} ${holeRadius}, ${0}, ${overPiFlag}, 0, ${point4.x} ${point4.y}`;

            segment.setAttribute('id', 'segment');
            segment.setAttribute('d', segmentPathMainArc + segmentPathLine + segmentPathInnerArc);
            segment.setAttribute('fill', 'url(#segm_' + id + ')');
            segment.setAttribute('filter', 'url(#filt_' + id + ')');

            /////cut imitation
            var outerLine = document.createElementNS('http://www.w3.org/2000/svg', 'path');
            var innerLine = document.createElementNS('http://www.w3.org/2000/svg', 'path');

            var halfCutThick = cutThick / 2;

            var outerAngleArcPoint = this.calcTrig(flags, sectorAngleRad, outerRadius + halfCutThick);
            var innerAngleArcPoint = this.calcTrig(flags, sectorAngleRad, holeRadius - halfCutThick);

            var arcPoint1 = {
                x: point1.x,
                y: halfCutThick,
            };
            var arcPoint2 = {
                x: outerAngleArcPoint.x + startPointX,
                y: outerAngleArcPoint.y + outerRadius + cutThick
            };
            var arcPoint3 = {
                x: innerAngleArcPoint.x + startPointX,
                y: innerAngleArcPoint.y + outerRadius + cutThick,
            };
            var arcPoint4 = {
                x: startPointX,
                y: dRad + cutThick + halfCutThick
            };

            outerLinePath = `M${arcPoint1.x} ${arcPoint1.y} A${outerRadius + halfCutThick} ${outerRadius + halfCutThick}, ${0}, 
          						${overPiFlag}, 1, ${arcPoint2.x} ${arcPoint2.y}`;
            innerLinePath = `M${arcPoint4.x} ${arcPoint4.y} A${holeRadius - halfCutThick} ${holeRadius - halfCutThick}, ${0},
          						 ${overPiFlag}, 1, ${arcPoint3.x} ${arcPoint3.y}`;
            cutThick = cutThick == 0 ? cutThick : cutThick + 1; //for smooth arc lines, add 1 to stroke thickness
            outerLine.setAttribute('style', `stroke:${cutColor};stroke-width:${cutThick}`);
            outerLine.setAttribute('fill', 'none');
            outerLine.setAttribute('d', outerLinePath);
            innerLine.setAttribute('style', `stroke:${cutColor};stroke-width:${cutThick}`);
            innerLine.setAttribute('fill', 'none');
            innerLine.setAttribute('d', innerLinePath);
            //////////////////////////////

            svg._svg.appendChild(segment);
            svg._svg.appendChild(outerLine);
            svg._svg.appendChild(innerLine);
            this.setGradient(outerRadius, holeRadius, svg, startPointX, cutThick);
        },

        getQuadrantFlags: function (angle) {
            if (angle <= 90) return quadFlags = { xf: true, yf: false, roundAngle: angle };
            if (angle > 90 && angle <= 180) return quadFlags = { xf: true, yf: true, roundAngle: angle - 90 };
            if (angle > 180 && angle <= 270) return quadFlags = { xf: false, yf: true, roundAngle: angle - 180 };
            if (angle > 270 && angle <= 360) return quadFlags = { xf: false, yf: false, roundAngle: angle - 270 };
        },

        calcTrig: function (flags, angleRad, radius) {
            var negFactX = flags.xf ? 1 : -1;
            var negFactY = flags.yf ? 1 : -1;
            var trigFunX = flags.xf == flags.yf ? Math.cos : Math.sin;
            var trigFunY = flags.xf == flags.yf ? Math.sin : Math.cos;
            var x = negFactX * radius * trigFunX(angleRad);
            var y = negFactY * radius * trigFunY(angleRad);
            return point = { x: x, y: y };
        },

        setGradient: function (outerRadius, innerRadius, svg, startPoint, cutThick) {
            var gradient = document.createElementNS('http://www.w3.org/2000/svg', 'radialGradient');
            var gradStop1 = document.createElementNS('http://www.w3.org/2000/svg', 'stop');
            var gradStop2 = document.createElementNS('http://www.w3.org/2000/svg', 'stop');
            var gradStop3 = document.createElementNS('http://www.w3.org/2000/svg', 'stop');
            var gradStop4 = document.createElementNS('http://www.w3.org/2000/svg', 'stop');
            var gradStop5 = document.createElementNS('http://www.w3.org/2000/svg', 'stop');
            var defs = document.createElementNS('http://www.w3.org/2000/svg', 'defs');
            var filter = document.createElementNS('http://www.w3.org/2000/svg', 'filter');
            var colorMatrix = document.createElementNS('http://www.w3.org/2000/svg', 'feColorMatrix');
            var id = svg._container.id;
            gradient.setAttribute('id', 'segm_' + id);
            gradient.setAttribute('cx', startPoint);
            gradient.setAttribute('cy', outerRadius + cutThick);
            gradient.setAttribute('r', outerRadius);
            gradient.setAttribute('gradientUnits', 'userSpaceOnUse');

            var radRatio = innerRadius / outerRadius;
            var dRadRatio = 1 - radRatio;

            gradStop1.setAttribute('offset', radRatio);
            gradStop1.setAttribute('style', "stop-color:#666666");
            gradient.appendChild(gradStop1);

            gradStop2.setAttribute('offset', radRatio + dRadRatio * 0.1158);
            gradStop2.setAttribute('style', "stop-color:#999999");
            gradient.appendChild(gradStop2);

            gradStop3.setAttribute('offset', radRatio + dRadRatio * 0.4958);
            gradStop3.setAttribute('style', "stop-color:#C7C7C7");
            gradient.appendChild(gradStop3);

            gradStop4.setAttribute('offset', radRatio + dRadRatio * 0.89);
            gradStop4.setAttribute('style', "stop-color:#929599");
            gradient.appendChild(gradStop4);

            gradStop5.setAttribute('offset', 1);
            gradStop5.setAttribute('style', "stop-color:#666666");
            gradient.appendChild(gradStop5);

            filter.setAttribute('id', 'filt_' + id);
            colorMatrix.setAttribute('id', 'feColorMatrix');
            colorMatrix.setAttribute('values', this.mvc.model.get(Enums.ParameterRoles.FILL_COLOR));
            filter.appendChild(colorMatrix);
            defs.appendChild(filter);
            svg._svg.appendChild(defs);
            svg._svg.appendChild(gradient);
        },

        onFillColorChanged: function (event) {
            var svg = this.svgRoot;
            if (svg != null) {
                var colorMatrix = document.createElementNS('http://www.w3.org/2000/svg', 'feColorMatrix');
                colorMatrix.setAttribute('id', 'feColorMatrix')
                colorMatrix.setAttribute('values', event);
                var oldMatrix = svg._svg.getElementById('feColorMatrix');
                var parent = oldMatrix.parentNode;
                parent.replaceChild(colorMatrix, oldMatrix);
            }
        },

        onResize: function () {
            var svg = this.svgRoot;
            if (svg != null) {

                var fc = svg._svg.childNodes[0];
                while (fc) {
                    svg._svg.removeChild(fc);
                    fc = svg._svg.childNodes[0];
                }
                var controlHeigthPx = this.mvc.model.getHeight();
                var controlWidthPx = this.mvc.model.getWidth();

                svg.configure({ viewBox: "0 0 " + controlWidthPx + " " + controlHeigthPx }, false);
                this.createTruncatedTore(svg);
            }
        },

    });

    return TruncatedToreController;
});

