﻿// <copyright file="SchemeModel.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

define(['common/Enums', 'base/ContainerModel'], function (Enums, ContainerModel) {
    //here we will define model for whole scheme
    //this file will be generated by app

    var WindowModel = ContainerModel.extend({

        init: function (type, parentResourceManager) {
            this._super(type, parentResourceManager);
            this.serviceParameters = type.serviceParameters;
            this.ClassName = 'WindowModel';
            this.needPrint = false;
        },

        initModel: function (model) {
            if (model.url_parameters && model.url_parameters.print) {
                this.needPrint = model.url_parameters.print;
            }
            this.objectId = model.objectId;
            this.applyModel(model);
            this.fireOnInit();
            this.fireNotConnectedPropertiesChanged();
            this.fireOnAfterInit();
        },

        getSizeProportionType: function(){
            return this.get(Enums.ParameterRoles.PROPORTION_TYPE);
        },
        fireNotConnectedPropertiesChanged: function(){
            for (var property in this._data) {
                if (this.type._connectionsHandler.connections['/' + property]) //у параметра есть исходящая связь
                    continue;
                this.firePropertyChanged(property);
            }
        },
        fireConnectedPropertiesChanged: function () {
            for (var property in this._data) {
                if (this.type._connectionsHandler.connections['/' + property]) //у параметра есть исходящая связь
                    this.firePropertyChanged(property);
            }
        },
        hasFBConnections: function () {
            return this.serviceParameters[Enums.ParameterRoles.HAS_FB_CONNECTIONS];
        }
    });

    return WindowModel;
});
