﻿define(['core/actions/Action', 'common/Error'],
    function (OpenWindowActionBase, Error) {

        return OpenWindowActionBase.extend({
            executeInternal: function(context, resolve, reject, notify) {
                if (this.constants.Frame) {
                    $('div[data-control-id=' + this.constants.Frame + ']')[0].innerHTML =
                        '<iframe style="width:100%;height:100%;" frameborder="0" src="' + this.get('Address') + '" />';
                    return resolve();
                }
                try {
                    if (this.get('OpenNew') == true) {
                        window.open(this.get('Address'), '_blank');
                    } else {
                        window.open(this.get('Address'), '_self');
                    }
                } catch (e) {
                    Error.warn("Некорректный адрес " + this.get('Address'));
                }
                return resolve();
            }
        });
    });