﻿// <copyright file="SetParameterValueAction.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

define(['common/Enums', 'core/actions/Action', 'core/ImplicitConvertations'], function (Enums, Action, ImplicitConvertations) {

    var SetParameterValueAction = Action.extend({
        executeInternal: function (context, resolve, reject, notify) {
            var source = this.getProperty(Enums.ParameterRoles.SOURCE);
            var targetPropertyType = this.getPropertyType(Enums.ParameterRoles.TARGET);
            ImplicitConvertations.convert(source, targetPropertyType);
            source.typeName = targetPropertyType;
            this.setProperty(Enums.ParameterRoles.TARGET, source, false, true);
            resolve();
        }       
    });


    return SetParameterValueAction;
});