// <copyright file="ProtocolTaskAdapter.js" company="">
// , 2014
// </copyright>
// 

define(['helpers/contextResolver', 'core/adapters/BaseAdapter'], function (contextResolver, BaseAdapter) {

    var ProtocolTaskAdapter = BaseAdapter.extend({
        init: function (settings, type) {
            this._super(settings, type);                 

            this.path = settings.path;
            this.propertyPath = settings.propertyPath;
            this.adapterType = "ProtocolTaskAdapter";
            this.dataSource =  this.settings.dataSource;
        },     

        getDataSource: function (ctx) {
            return contextResolver.resolve(this.path, ctx).controller.getVariablesSource(this.dataSource);
        }
    });	

    return ProtocolTaskAdapter;
});