﻿// <copyright file="BaseFunctionBlock.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 


define(['common/Enums', 'base/Model', 'controls/ParametersFactory', 'common/Utilites', 'core/functionBlocks/standardFB/standardFBMetadata'],
    function (Enums, Model, ParametersFactory, Utilites, StandardFBMetadata) {

        var TaskWrapperModel = Model.extend({           
            init: function (functionBlocks) {
                this._super();
                this.ClassName = 'TaskWrapperModel';
                this.changedParams = {}; //path: value      
                this.functionBlocks = functionBlocks;
            },

            getName: function () {
                return this.name;
            },

            _getPropertyByName: function (currentProperty, namePart) {
                if (currentProperty.value[namePart] === undefined) {
                    //свойсво запрашивается впервые - создаем
                    currentProperty.value[namePart] = this._createSubParameter(currentProperty, namePart);
                }

                return currentProperty.value[namePart];
            },

            _createSubParameter: function (currentParam, propertyName) {
                var typeDesc;

                //первый уровень - _data, поэтому у currentParam не будет типа.    
                if (currentParam.typeName === undefined && this.functionBlocks[propertyName] !== undefined) {
                    //т.к ФБ по структуре аналогичен объекту, то у него будут вложенные св-ва     
                    return {
                        typeName: propertyName,
                        type: Enums.type.fb,
                        value: {}
                    };
                }

                var fb = this._getFBbyType(currentParam.typeName);
                if (fb !== undefined) {
                    //текущий параметр - ФБ
                   
                    typeDesc = fb[propertyName];
                    return {
                        typeName: typeDesc.type,
                        value: this._getFBbyType(typeDesc.type) !== undefined ? {} : undefined
                    }                   
                } else {
                    var currentParamTypeDesc = ParametersFactory.getType(currentParam.typeName);
                    typeDesc = currentParamTypeDesc.description[propertyName];
                    if (typeDesc.type === Enums.type.object) {
                        typeDesc.value = {};
                    } else {
                        typeDesc.value = undefined;
                    }
                }

                return typeDesc;
            },

            _getFBbyType: function (typeName) {
                return this.functionBlocks[typeName] || StandardFBMetadata[typeName];
            },

            _getPropertyByArrayIndex: function (currentProperty, index) {
                return currentProperty.value[index];
            },

            setParam: function (path, value) {
                var propType = this.getPropertyType(path);
                if (this._isArrayType(propType)) {
                    value = this._convertFromArray(JSON.parse(propType), 0, value);
                }
                this.set(path, value);
            },

            getParam: function (path) {
                var propType = this.getPropertyType(path);                
                if (this._isArrayType(propType)) {
                    return this._convertToArray(JSON.parse(propType), 0, this.getProperty(path));
                }

                return this.get(path);
            },

            _convertToArray: function (metadata, curr, property) {
                var range = metadata.ArrayMetadata.subranges[curr],
                  i,
                  nextRange = curr + 1,
                  arr = [];
                for (i = 0; i < range.End - range.Begin + 1; i++) {
                    if (curr === metadata.ArrayMetadata.subranges.length - 1) {
                        arr.push(property.value[i]);
                    } else {
                        arr.push(this._convertToArray(metadata, nextRange, property.value[i].value));
                    }
                }

                return arr;
            },

            _convertFromArray: function (metadata, curr, val) {
                var range = metadata.ArrayMetadata.subranges[curr],
                    i,
                    nextRange = curr + 1,
                    arr = [];
                    for (i = 0; i < range.End - range.Begin + 1; i++) {
                        if (curr === metadata.ArrayMetadata.subranges.length - 1) {
                            arr.push({
                                typeName: metadata.ArrayMetadata.oftype,
                                value: val[i]
                            });
                        } else {
                            arr.push({
                                value: this._convertFromArray(metadata, nextRange, val[i])
                            });
                        }
                }

                return arr;
            },

            getData: function () {
                return this.changedParams;
            },

            _isArrayType: function (propType) {
                if (propType.indexOf('ArrayMetadata') != -1) {
                    return true;
                }

                return false;
            }
        });

        return TaskWrapperModel;
    });