/**
 * Created by livepanzo on 09.10.14.
 */
var StandartFunctions = {};
var StandartFunctionsErrors = {
    DIV_0: function () { throw new Error("division by zero"); },
    LOG_0: function () { throw new Error("out of range"); }
}


StandartFunctions.ABS = function (a) {
    return Math.abs(a);
};

StandartFunctions.ADD = function (a, b) {
    return a + b;
};

StandartFunctions.SUB = function (a, b) {
    return a - b;
};

StandartFunctions.MOD = function (a, b) {
    return a % b;
};

StandartFunctions.DIV_REAL_REAL = function (a, b) {
    return StandartFunctions.DIV(a, b);
};
//Исправить
StandartFunctions.DIV_INT_INT = function (a, b) {
    return Math.round(StandartFunctions.DIV(a, b));
};

StandartFunctions.MUL = function (a, b) {
    return a * b;
};

StandartFunctions.DIV = function (a, b) {
    if (b === 0) {
        StandartFunctionsErrors.DIV_0();
    };
    return a / b;
};


StandartFunctions.SHL_LWORD = function(a, b) {
    return a << b;
};

StandartFunctions.SHL_DWORD = function(a, b){
    return a << b;
};

StandartFunctions.SHL_WORD = function(a, b) {
    return a << b;
};

StandartFunctions.SHL_BYTE = function(a, b) {
    return a << b;
};

StandartFunctions.SHR_LWORD = function(a, b) {
    return a >>> b;
};

StandartFunctions.SHR_DWORD = function(a, b) {
    return a >>> b;
};

StandartFunctions.SHR_WORD = function(a, b) {
    return a >>> b;
};

StandartFunctions.SHR_BYTE = function(a, b) {
    return a >>> b;
};
//need change
StandartFunctions.ROR_LWORD = function(val, shift){
    return (val >> shift) | (val << (64 - shift));
};

StandartFunctions.ROR_DWORD = function(val, shift){
    return (val >> shift) | (val << (32 - shift));
};

StandartFunctions.ROR_WORD = function(val, shift){
    return ((val >> shift) | (val << (32 - shift))) & 0xFFFF;
};

StandartFunctions.ROR_BYTE = function(val, shift){
    return ((val >> shift) | (val << (8 - shift))) & 0xFF;
};
//need change
StandartFunctions.ROL_LWORD = function(val, shift){
    return (val << shift) | (val >> (64 - shift));
};

StandartFunctions.ROL_DWORD = function(val, shift){
    return (val << shift) | (val >> (32 - shift));
};

StandartFunctions.ROL_WORD = function(val, shift){
    return ((val << shift) | (val >> (16 - shift))) & 0xFFFF;
};

StandartFunctions.ROL_BYTE = function(val, shift){
    return ((val << shift) | (val >> (8 - shift))) & 0xFF;
};

StandartFunctions.OR_PARAMS_LWORD = function(a, b) {
    return a | b;
};
StandartFunctions.OR_PARAMS_BOOL = function(a, b) {
    return a | b;
};

StandartFunctions.AND_PARAMS_LWORD = function(a, b) {
    return a & b;
};
StandartFunctions.AND_PARAMS_BOOL = function(a, b) {
    return a & b;
};

StandartFunctions.XOR_PARAMS_LWORD = function(a, b) {
    return a ^ b;
};
StandartFunctions.XOR_PARAMS_BOOL = function(a, b) {
    return a ^ b;
};
//LWORD ??? уточнить 
StandartFunctions.NOT_LWORD = function(a) {
    return  0xffffffffffffffff - a;
};
StandartFunctions.NOT_DWORD = function(a) {
    return 0xffffffff - a;;
};
StandartFunctions.NOT_WORD = function(a) {
    return 0xffff - a;
};
StandartFunctions.NOT_BYTE = function(a) {
    return 0xff - a;
};
StandartFunctions.NOT_BOOL = function(a) {
    return !a;
};

StandartFunctions.MAX = function(a, b) {
   
    return a >= b ? a : b;
};

StandartFunctions.MIN = function(a, b) {

    return a <= b ? a : b;
};

StandartFunctions.LIMIT = function(mn, IN1, mx) {
    if (mn > IN1)
        return mn;
    if (mx < IN1)
        return mx;
    return IN1;

};

StandartFunctions.GT = function(a, b) {
    return  a > b ? 1 : 0;
};
StandartFunctions.GE = function(a, b) {
    return a >= b ? 1 : 0;
};
StandartFunctions.EQ = function(a, b) {
    return a = b ? 1 : 0;
};
StandartFunctions.LE = function(a, b) {
    return a <= b ? 1 : 0;
};
StandartFunctions.LT = function(a, b) {
    return a < b ? 1 : 0;
};
StandartFunctions.NE = function(a, b) {
    return a != b ? 1: 0;
};

StandartFunctions.ADD_TIME_OF_DAY = function(a, b) {
    return a + b;
};
StandartFunctions.ADD_TIME_OF_DAY_TIME = function(in1, in2) {
    return in1 + in2;
}
StandartFunctions.ADD_DATE_AND_TIME_TIME = function(in1,in2){
    return in1 + in2;
}
StandartFunctions.SUB_TIME = function(in1 , in2) {
    return in1 - in2;
}
StandartFunctions.SUB_DATE_DATE = function(in1 , in2) {
    return in1 - in2;
}
StandartFunctions.SUB_TIME_OF_DAY_TIME = function(in1 , in2) {
    return in1 - in2;
}
StandartFunctions.SUB_TIME_OF_DAY_TIME_OF_DAY = function(in1 , in2) {
    return in1 - in2;
}
StandartFunctions.SUB_DATE_AND_TIME_TIME = function(in1 , in2) {
    return in1 - in2;
}
StandartFunctions.SUB_DATE_AND_TIME_DATE_AND_TIME = function(in1 , in2) {
    return in1- in2;
}
StandartFunctions.MUL_TIME_ANY_NUM = function(in1 , in2) {
    return in1*in2;
}
StandartFunctions.DIV_TIME_ANY_NUM = function(in1, in2) {
    return in1/in2;
}
StandartFunctions.CONCAT_PARAMS_ANY_STRING = function(str1, str2) {
    return str1 + str2;
}
StandartFunctions.CONCAT_DATE_TIME_OF_DAY = function(in1 , in2){
    return in1 + in2;
}
/* 
            ADD_TIME_OF_DAY_TIME    = ADD,\n"
"           ADD_DATE_AND_TIME_TIME  = ADD,\n"
"           SUB_TIME            = SUB,\n"
"           SUB_DATE_DATE           = SUB,\n"
"           SUB_TIME_OF_DAY_TIME    = SUB,\n"
"           SUB_TIME_OF_DAY_TIME_OF_DAY = SUB,\n"
"           SUB_DATE_AND_TIME_TIME = SUB,\n"
"           SUB_DATE_AND_TIME_DATE_AND_TIME = SUB,\n"
"           MUL_TIME_ANY_NUM        = MUL,\n"
"           DIV_TIME_ANY_NUM        = DIV,\n"
"           CONCAT_PARAMS_ANY_STRING = CONCAT,\n"
"           CONCAT_DATE_TIME_OF_DAY = ADD,\n"
*/
StandartFunctions.MUX = function(k, IN1, IN2){
  if (k === 0) return IN1;
  if (k === 1) return IN2;
  return 0;
};
StandartFunctions.MOVE = function(a){
    return a;
};
StandartFunctions.SEL = function(G, IN1, IN2){
    return G ? IN2 : IN1;
};

StandartFunctions.BYTE_BCD_TO_USINT = function(bcd){
    var n = 0;
    var m = 1;
    for(var i = 0; i<bcd.length; i+=1) {
        n += (bcd[bcd.length-1-i] & 0x0F) * m;
        n += ((bcd[bcd.length-1-i]>>4) & 0x0F) * m * 10;
        m *= 100;
    }
    return n;
};

/*"           BYTE_BCD_TO_USINT   = BYTE_BCD_TO_USINT,\n"
"           WORD_BCD_TO_UINT    = WORD_BCD_TO_UINT,\n"
"           DWORD_BCD_TO_UDINT  = DWORD_BCD_TO_UDINT,\n"
"           LWORD_BCD_TO_ULINT  = LWORD_BCD_TO_ULINT,\n"
"           USINT_TO_BCD_BYTE   = USINT_TO_BCD_BYTE,\n"
"           UINT_TO_BCD_WORD    = UINT_TO_BCD_WORD,\n"
"           UDINT_TO_BCD_DWORD  = UDINT_TO_BCD_DWORD,\n"
"           ULINT_TO_BCD_LWORD  = ULINT_TO_BCD_LWORD,\n"
"       
*/
StandartFunctions.REAL_TO_INT = function(d){
    return Math.round(d);
};

StandartFunctions.TIME_TO_REAL = function (a) {
    return a;
}

StandartFunctions.REAL_TO_TIME = function (t) {
    return new Date().setMilliseconds(t);
}

StandartFunctions.TIME_TO_TOD = function (t) {
    return new Date(t);
}

StandartFunctions.TOD_TO_TIME = function (t) {
    return t.getMilliseconds();
}

StandartFunctions.TIME_TO_DT = function (t) {
    return new Date(t).getTime();
}

StandartFunctions.TIME = function () {
    return Date.now();
}
StandartFunctions.GET_TIME = function (d) {
    return d.getTime();
}

/*
"         
"           DT_TO_DATE          = FILETIME.DT_TO_DATE,\n"
"           DT_TO_TOD           = FILETIME.DT_TO_TOD,\n"
"           TIME_TO_TOD         = FILETIME.TIME_TO_TOD,\n"
"           TOD_TO_TIME         = function(time) return time end,\n"
"           TIME                = FILETIME.GetSysTimeMs,\n"
"           GET_TIME            = FILETIME.GetTime,\n"
"           GET_UTC_TIME        = FILETIME.GetTime,\n"
"           GET_LOCAL_TIME      = FILETIME.GetLocalTime,\n"

"           DATE_TO_DWORD       = FILETIME.DATE_TO_DWORD,\n"
"           DT_TO_DWORD         = FILETIME.DT_TO_DWORD,\n"
"           DATE_TO_UDINT       = FILETIME.DATE_TO_DWORD,\n"
"           DT_TO_UDINT         = FILETIME.DT_TO_DWORD,\n"
"           DWORD_TO_DATE       = FILETIME.DWORD_TO_DATE,\n"
"           DWORD_TO_DT         = FILETIME.DWORD_TO_DT,\n"
"           UDINT_TO_DATE       = FILETIME.DWORD_TO_DATE,\n"
"           UDINT_TO_DT         = FILETIME.DWORD_TO_DT,\n"
"           


*/
StandartFunctions.TRUNC = function(x) {
    return x < 0 ? Math.ceil(x) : Math.floor(x);
};
StandartFunctions.SQRT = function(a) {
    return Math.sqrt(a);
};
StandartFunctions.LN = function(a) {
    if(a === 0) {
        StandartFunctionsErrors.LOG_0();
    }
    return Math.log(a);
};
StandartFunctions.LOG = function(a) {
    return Math.log(a)/Math.LN10;
};
StandartFunctions.EXP = function(a) {
    return Math.exp(a);
};
StandartFunctions.SIN = function(x) {
    return Math.sin(x);
};
StandartFunctions.COS = function(x) {
    return Math.cos(x);
};
StandartFunctions.TAN = function(x) {
    return Math.tan(x);
};
StandartFunctions.ASIN = function(x) {
    return Math.asin(x);
};
StandartFunctions.ACOS = function(x) {
    return Math.acos(x);
};
StandartFunctions.ATAN = function(x) {
    return Math.atan(x);
};
StandartFunctions.EXPT = function(x, y){
    return Math.pow(x, y);
};

StandartFunctions.LEN = function(str) {
    return str.length;
};
//Функция возвращает L первых символов строки 
StandartFunctions.LEFT = function(str, l) {
    return str.substr(0, l);
};
//Функция возвращает L последних символов строки
StandartFunctions.RIGHT = function(str, l) {
    return str.slice(-l);
};
//Функция возвращает L символов из строки str, начиная  с P-го символа: 
StandartFunctions.MID = function(str, p, l){
    return str.substr(p, l);
};
StandartFunctions.INSERT = function(str1, str2, p) {
    var strTmp1 = StandartFunctions.LEFT(str1, p);
    var strTmp2 = str1.substring(p);
    return strTmp1 + str2 + strTmp2;
};

StandartFunctions.DELETE = function(str, p, l) {
    var strTmp1 = StandartFunctions.LEFT(str, p);
    var strTmp2 = str.substring(p + l);
    return strTmp1 + strTmp2;
};
StandartFunctions.REPLACE = function(str1, str2, l, p) {

    return StandartFunctions.INSERT(StandartFunctions.DELETE(str1, p, l-p),str2, p);
};
StandartFunctions.FIND = function(s, w) {
    return s.indexOf(w);
};
StandartFunctions.TO_BOOL = function(w){
    return w === 0 ? false : true;

};
StandartFunctions.BOOL_TO_BYTE = function(b) {
    return ~~b;
};
StandartFunctions.TO_STRING = function (str) {
    return str.toString();
}

StandartFunctions.GetBit = function (num, pos) {
    return ((num >> pos) & 0x1);
}

StandartFunctions.SetBit = function(num, pos) {
    return ((0x1 << pos) | num);
}

StandartFunctions.TO_BYTE = function (b) {
    var round = Round(b);
    return round & 0xFF;
};

StandartFunctions.TO_WORD = function (b) {
    var round = Round(b);
    return round & 0xFFFF;
};

StandartFunctions.TO_SINT = function (b) {
    var round = Round(b);
    return round & 0xFF;
};

StandartFunctions.TO_INT = function (b) {
    var round = Round(b);
    return round & 0xFFFF;
};

StandartFunctions.TO_LINT = function (b) {
    var round = Round(b);
    return round;
};

StandartFunctions.TO_DINT = function (b) {
    var round = Round(b);
    return round & 0xFFFFFFFF;
};

StandartFunctions.TO_DWORD = function (b) {
    var round = Round(b);
    return (round & 0xFFFFFFFF) >>> 0;
};

StandartFunctions.TO_LWORD = function (b) {
    var round = Round(b);
    return round;
};

StandartFunctions.TO_REAL = function (b) {
    return Number(b);
};

StandartFunctions.TO_LREAL = function (b) {
    return Number(b);
};

/*
 
"           
"           TO_BYTE             =   StandardFunctionsC.TO_BYTE,"
"           TO_WORD             =   StandardFunctionsC.TO_WORD,"
"           TO_DWORD            =   StandardFunctionsC.TO_DWORD,"

"           TO_STRING           = tostring,\n"

"           GetBit              = StandardFunctionsC.GetBit,"
"           SetBit              = StandardFunctionsC.SetBit,"

"           
"           CopyTable           = CopyTable\n"
*/
StandartFunctions.ADJUST_TO_TYPE =  function (a, b) {
    return a;
};

StandartFunctions.ADJUST_TO_TYPE_REAL =  function (a, b) {
    return a;
};

StandartFunctions.CopyTable = function (out) {
    out = out || {};

    for (var i = 1; i < arguments.length; i++) {
        var obj = arguments[i];

        if (!obj)
            continue;

        for (var key in obj) {
            if (obj.hasOwnProperty(key)) {
                if (typeof obj[key] === 'object')
                    deepExtend(out[key], obj[key]);
                else
                    out[key] = obj[key];
            }
        }
    }

    return out;
};

StandartFunctions.LOWER_BOUND = function (a, b) {
    return 1;
};

StandartFunctions.UPPER_BOUND = function (a, b) {
    if (b <= 1)
        return a.length;
    else {
        for (var i = 1; i < b; i++)
            a = a[0];
        return a.length;
    }
};

Round = function (b) {
    if (b === true) return 1;
    if (b === false) return 0;
    return Number((b).toFixed());
}