﻿define(['core/L10n'], function (L10n) {

    var PermissionChecker = {};

    PermissionChecker.check = function (type, ctx, result, args, act) {
        var control = ctx.mvc;
        while (control && control.model.permissions) {
            var permission = control.model.permissions[type];
            if (permission && permission[this.currentOperator]) {
                result.allow = permission[this.currentOperator].Enable || result.allow;
                result.deny = permission[this.currentOperator].Disable || result.deny;
                result.confirmation = permission[this.currentOperator].Confirmation || result.confirmation;
                result.writelog = permission[this.currentOperator].WriteLog || result.writelog;
                break;
            }
            control = control._parent;
        }

        if (this.currentGroups === undefined || this.currentGroups.length == 0) {
            this.setCurrentGroups(ctx);
        }

        for (var group of this.currentGroups) {
            result = this.mergePermissions(ctx, type, result, group);
        }

        if (result.deny) {
            result.allow = false;
        }
        if (result.allow) {
            var actType = type;
            if (result.confirmation && (!result.silent)) {
                var that = this;               
                var dialog = $("<div>" + L10n.get("actions." + type) + "</div>").dialog({
                    autoOpen: true,
                    modal: true,
                    title: L10n.get("messages.confirmAction"),
                    resizable: false,
                    dialogClass: "confirm",
                    collapseEnabled: false,
                    buttons: {
                        "confirm": {
                            text: L10n.get("controls.okText"),
                            class: 'confirmbtn btn',
                            click: function () {
                                result.allow_action(args);
                                if (result.writelog && that.dataAdapter) {
                                    that.setCurrentEvent("Click");
                                    PermissionChecker.reportAction(ctx, actType, result.silent);
                                }
                                $(this).dialog("close");
                                $(this).dialog('destroy').remove()
                            },

                        },
                        "cancel": {
                            text: L10n.get("controls.cancelText"),
                            class: 'confirmbtn btn',
                            click: function () {
                                result.deny_action(args);
                                $(this).dialog("close");
                                $(this).dialog('destroy').remove()
                            }
                        }
                    }
                });
            } else {
                result.allow_action(args);
                if (actType == "Control" && !result.silent && result.writelog) {
                    this.eventType = "Click";
                    this.reportAction(ctx, actType, false);
                }
            }
        } else
            result.deny_action(args);

    },
        PermissionChecker.setOperator = function (operator) {
            this.currentOperator = operator;
        },
        PermissionChecker.getOperator = function () {
            return this.currentOperator;
        },
        PermissionChecker.needCheck = function () {
            if (this.currentOperator) {
                return true;
            }
            else {
                return false;
            }
        },

        PermissionChecker.mergePermissions = function (ctx, type, result, group) {
            if (this.currentGroups !== undefined) {
                var control = ctx.mvc;
                while (control && control.model.permissions) {
                    var permission = control.model.permissions[type];
                    if (permission && permission[group]) {
                        result.allow = permission[group].Enable || result.allow;
                        result.deny = permission[group].Disable || result.deny;
                        result.confirmation = permission[group].Confirmation || result.confirmation;
                        result.writelog = permission[group].WriteLog || result.writelog;
                        break;
                    }
                    control = control._parent;
                }
            }
            return result;
        },

        PermissionChecker.setGroups = function (groupArray) {
            this.currentGroups = groupArray;
        },

        PermissionChecker.setCurrentGroups = function (ctx) {
            var groups = ctx.mvc.model.type.groups;
            this.currentGroups = [];
            for (group in groups) {
                for (var i = 0; i < groups[group].length; i++) {
                    if (groups[group][i] == this.currentOperator) {
                        this.currentGroups.push(group);
                    }
                }
            }
            return;
        },

        PermissionChecker.getCurrentGroups = function () {
            return this.currentGroups;
        },

        PermissionChecker.setDataAdapter = function (dataAdapter) {
            if (PermissionChecker.needCheck()) {
                this.dataAdapter = dataAdapter;
            }
        },

        PermissionChecker.setCurrentEvent = function (eventType) {
            this.eventType = eventType;
        },

        PermissionChecker.reportAction = function (context, act, silent) {
            var eventType = this.eventType || "load";
            if (eventType == "load") return;
            if (context.ClassName == "WindowController" && act == undefined) return;
            if (silent && !act) return;
            var elementId = context.validator.controlId;
            var elementName = context.mvc.model.shortName;
            var objectId = context.getParentObject();
            var userName = PermissionChecker.getOperator();
            var groupName = PermissionChecker.getCurrentGroups();
            var action = "Control";
            if (typeof (act) === 'object')
                action = act.type;
            if (typeof (act) === 'string')
                action = act;

            var assemlyString = String.format("{0} : {1} ({2}) {3} {4}", elementName, L10n.get("actions." + action), L10n.get("events." + eventType), userName, groupName);
            console.warn(assemlyString);
            var items = {
                time: new Date().getTime(),
                itemId: elementId,
                itemName: elementName,
                objectId: objectId,
                userName: userName,
                groupName: groupName,
                eventType: eventType,
                event: L10n.get("events." + eventType),
                actionType: action,
                action: L10n.get("actions." + action),
                text: assemlyString
            };
            this.dataAdapter.reportAction(items);
        },

        PermissionChecker.createResultObj = function (allowAct, denyAct, silent) {
            var result = {};
            result.allow_action = allowAct;
            result.deny_action = denyAct;
            result.allow = false;
            result.deny = false;
            result.writelog = false;
            result.confirmation = false;
            result.silent = silent;
            return result;
        }


    return PermissionChecker;
});