// <copyright file="JsonVariablesManager.js" company="">
// , 2014
// </copyright>
// 

define(['common/Enums', 'server/VariablesManager', 'server/jsonVariablesManager/JsonVariablesManagerModel'],
    function (Enums, VariablesManager, JsonVariablesManagerModel) {

        var JsonVariablesManager = VariablesManager.extend({
            init: function (options, dataAdapterConstructor) {
                this.dataAdapterConstructor = dataAdapterConstructor;
                this._super(options);
                this.className = 'JsonVariablesManager';
                //      -    set                           
                this.waitingObjects = {};
                this.propsToSet = [];
            },

            initInternal: function () {
                this.model = new JsonVariablesManagerModel(this.options);                
                this.model.subscribePropertyChanged(this._onDataSourceSettingChanged, this);
                this._super();
                this.serverStateManager.set(this.stateVars.Connected, true);
            },
            _onDataSourceSettingChanged: function (event) {
                switch (event.property) {
                    case Enums.ParameterRoles.IS_ENABLED:
                        var active = this.model.getIsActive();
                        if (active === true && !this.timer.started) {
                            this.timer.start();
                        } else if(active === false){
                            this.timer.stop();
                        }
                        break;
                    case Enums.ParameterRoles.INTERVAL:
                        this.timer.setInterval(this.model.getInterval());
                        break;
                }              
            },

            addToSubscription: function (vars, objectId) {
                //  
                //  ,   
                this._super(vars);
                this.waitingObjects[objectId] = false;
            },

            _createDataAdapter: function (options) {
                return new this.dataAdapterConstructor(this.serverStateManager, this.model);
            },

            subscribe: function () {

                if (this.initialized === false && this.variables.get.protocol.length > 0) {
                    this._addGetTimer();
                }

                return Promise.resolve();
            },

            setProperty: function (name, newProperty, silent, force) {                
                this.propsToSet.push({
                    propName: name,
                    propObj: newProperty
                });
            },          

            getProperty: function (arg) {
                return this.model.getProperty(arg);
            },

            getPropertyType: function (arg) {
                return this.model.getPropertyType(arg);
            },

            _deleteSubscription: function () {
                return Promise.resolve();
            },

            _unsubscribeVars: function (monitoredItemsIds) {
                return Promise.resolve();
            },

            _getAllSucceed: function (data) {
                this.model.setJson(Enums.ParameterRoles.VALUE, data);
                this._afterGetAllSucceed();
                this.fireServerErrorStateChanged({ isError: false, id: this.options.id });
            },

            _getAllFailed: function (reason) {
                this.fireServerErrorStateChanged({ isError: true, id: this.options.id });
                this._afterGetAllSucceed();
                return Promise.reject(String.format('Query: {0}, {1} code: {2}, ',
                    reason.data.queryType, reason.data.url, reason.data.code));
            },

            _afterGetAllSucceed: function () {
                var objectIds = Object.keys(this.waitingObjects),
                    i;
                if (objectIds.length > 0) {
                    for (i = 0; i < objectIds.length; i++) {
                        this._serverDataReady(objectIds[i]);
                        this.eventTarget.removeAllListeners(this.SERVER_DATA_READY);
                        this.waitingObjects = {};
                    }
                }
            },

            _serverDataReady: function (objectId) {
                this.fireServerDataReady(objectId);
            },

            setAll: function () {
                if (this.propsToSet.length === 0) {
                    return Promise.resolve();
                }

                for (i = 0; i < this.propsToSet.length; i++) {
                    //slient=true, .      
                    //     
                    this.model.setProperty(this.propsToSet[i].propName, this.propsToSet[i].propObj, true, false);
                }
                
                return this.dataAdapter.writeData(this.model.getJson(Enums.ParameterRoles.VALUE))
                    .then(function (result) {
                        this.propsToSet = [];
                        return Promise.resolve(result);
                    }.bind(this));
            },

            subscribePropertyChanging: function (handler, context) {
                this.model.subscribePropertyChanging(handler, context);
            },

            subscribePropertyChangingOnce: function (handler, context) {
                this.model.subscribePropertyChangingOnce(handler, context);
            },

            unsubscribePropertyChanging: function (handler) {
                this.model.unsubscribePropertyChanging(handler);
            },

            subscribePropertyChanged: function (handler, context) {
                this.model.subscribePropertyChanged(handler, context);
            },

            subscribePropertyChangedOnce: function (handler, context) {
                this.model.subscribePropertyChangedOnce(handler, context);
            },

            unsubscribePropertyChanged: function (handler) {
                this.model.unsubscribePropertyChanged(handler);
            }
        });

        return JsonVariablesManager;
    });