﻿// <copyright file="VariablesSource.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 


define(['common/Enums', 'server/sources/VariablesSource', 'server/VariablesManagersHandler'],
    function (Enums, VariablesSource, VariablesManagersHandler) {

        return VariablesSource.extend({
            dataSourceKey: 'dataSourceId',
            getValuesKey: 'getValues',
            setValuesKey: 'setValues',
            init: function (ownerId) {
                this._super(ownerId);
                this.mplcVM = null;
            },

            _createVM: function (id) {
                return VariablesManagersHandler.get(id, this.ownerId, Enums.variablesManagersSubTypes.trend);
            },

            getArchiveData: function (oldMark, nextmark, resampleInterval) {
                if (this._getTrendVM()) {
                    return this._getTrendVM().getArchiveData(oldMark, nextmark, resampleInterval, this.itemIdToGraphId);
                }

                return Promise.resolve();
            },
            getAsyncArchiveData: function (oldMark, nextmark, resampleInterval) {
                if (this._getTrendVM()) {
                    return this._getTrendVM().getAsyncArchiveData(oldMark, nextmark, resampleInterval, this.itemIdToGraphId);
                }
                return Promise.resolve();
            },
            getArchiveInfo: function () {
                if (this._getTrendVM()) {
                    return this._getTrendVM().getArchiveInfo();
                }

                return {};
            },

            getPensInfo: function () {
                if (this._getTrendVM()) {
                    return this._getTrendVM().getPensInfo();
                }

                return {};
            },

            createVarForStringPen: function(id){
                return {
                    getValues: [{
                        dataSourceId: "MPLCDataSource",
                        itemId: 0,
                        operation: "move",
                        path: id,
                        taskId: 0,
                        type: Enums.serverType.lreal,
                        typeHash: 1
                    }],
                    setValues: []
                };
            },
            stopDataUpdate: function () {
                if (this._getTrendVM()) {
                    return this._getTrendVM().stopDataUpdate();
                }

                return Promise.resolve();
            },

            restartDataUpdate: function () {
                if (this._getTrendVM()) {
                    return this._getTrendVM().restartDataUpdate();
                }

                return Promise.resolve();
            },
            initArchive: function () {
                if (this._getTrendVM()) {
                    return this._getTrendVM().initArchive();
                }

                return Promise.resolve();
            },

            startTimer: function () {
                if (this._getTrendVM()) {
                    return this._getTrendVM().startTimer();
                }
                
                return Promise.resolve();
            },
            unsubscribeAll: function(){
                if (this._getTrendVM()) {
                    this._getTrendVM().unsubscribe();
                }
                return Promise.resolve();
            },
            updateArchiveInfo: function () {
                if (this._getTrendVM()) {
                    return this._getTrendVM().updateArchiveInfo();
                }
                return Promise.resolve();
            },

            getServerTime: function () {
                if (this._getTrendVM()) {
                    return this._getTrendVM().getServerTime();
                }
                return 0;
            },
            _getTrendVM: function () {
                //пока не понятно с архивами по JSON берем MPLC
                if (!this.mplcVM) {
                    var ids = Object.keys(this.variablesManagers);
                    var i;
                    for (i = 0; i < ids.length; i++) {
                        if (this.variablesManagers[ids[i]].type
                            === Enums.variablesManagersTypes.masterPLC) {
                            this.mplcVM = this.variablesManagers[ids[i]];
                            break;
                        }
                    }
                }

                return this.mplcVM;
            },

            _onServerDataReady: function (event) {
                this.fireSourceDataReady();
                this.eventTarget.removeAllListeners(Enums.eventType.sourceDataReady);
            }


        });
    });