#!/bin/bash

cmd=$1
shift 1

CURDATE=$(date +"%Y_%m_%d")
COUNT=0

logdir="/var/log/mplc4"

mkdir -p ${logdir} 2>/dev/null
echo "Started in $(date +"%Y_%m_%d-%H:%M:%S")" > ${logdir}/start_log.txt

START_OPTS="$2"
INST_OPTS=""

mplc_kill(){
	kill -INT $@ 2>/dev/null
}
mplc_regex(){
	local val=$1
	local reg=$2
	local res=$(echo "$val" | grep -E "$reg")
	# echo "$val -> $reg : $res : $([ -n "$res" ] && echo 0 || echo 1)" >> logs/start_log.txt
	[ -n "$res" ] && echo 0 || echo 1
}
mplc_rm(){
	for file in "$@"; do
		[ -e "$file" ] && rm -R "$file" || true
	done
}
mplc_nkill(){
	local pid=$(pidof $1 2>/dev/null)
	[ -z "$pid" ] && return 0
	mplc_kill $pid
}

mplc_fkill(){
	if [ -e "$1" ]; then
		mplc_kill $( cat "$1" )
		local is_ok=$?
		sleep 1
		if [ $is_ok != 0 ]; then 
			mplc_rm "$1"
		fi
	fi
}

if [ -z "$AS_LOCAL" ] && [ $(mplc_regex "$1" "^[0-9]+$") != 0 ] ; then
	START_OPTS="$START_OPTS $1"
fi

start(){
	local PORT=$1
	local PARAMS=$2
	echo "Start mplc on $PORT" >> ${logdir}/start_log.txt
	/opt/mplc4/mplc_service $PORT /opt/mplc4/mplc new $INST_OPTS $START_OPTS $PARAMS 1>> ${logdir}/start_log.txt 2>&1
}

run_with_check(){
	local NAME=$1
	local CMD=$2
	#$3 - path to pidfile
	local TMP=$( [ "$3" ] && [ -e "$3" ] && cat "$3" )
	local PIDS=$(pidof $NAME 2>/dev/null) || true
	if [ "$3" ] ; then
		if [ -z "$PIDS" ] || [ $(mplc_regex "$PIDS" "$TMP") != 0 ] ; then
			mplc_rm $3
			PIDS=
		else
			PIDS=$TMP
		fi
	fi
	if [ -n "$PIDS" ]; then
		if [ -z "$AS_LOCAL" ]; then
			echo "$NAME is already running. PID: $PIDS"
		fi
	else
		$($CMD)
	fi
}

run_as_service(){
	
	start 31550
	for i in $(seq 1 $COUNT); do
		start $((31550 + $i)) "/ea:$i"
	done
}

do_stop() {
	mplc_nkill mplc_service 		1>>${logdir}/start.log 2>&1
	mplc_nkill mplc					1>>${logdir}/start.log 2>&1
	while [ -n "$(pidof mplc)" ]; do sleep 1; done;
	return 0
}



case "$cmd" in
up)
	run_with_check mplc_service "run_as_service $1" || exit $?
	;;
down)
	do_stop $@ || exit $?
	;;
*)
	exit 1
esac

exit 0





